/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFileException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.FolderNameException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.RequiredFileEntryTypeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLTrashService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/edit_folder"}, service={MVCActionCommand.class})
public class EditFolderMVCActionCommand
extends BaseMVCActionCommand {
    private DLAppService _dlAppService;
    private DLTrashService _dlTrashService;

    protected void deleteExpiredTemporaryFileEntries(ActionRequest actionRequest) throws PortalException {
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)repositoryId);
        if (localRepository.isCapabilityProvided(TemporaryFileEntriesCapability.class)) {
            TemporaryFileEntriesCapability temporaryFileEntriesCapability = (TemporaryFileEntriesCapability)localRepository.getCapability(TemporaryFileEntriesCapability.class);
            temporaryFileEntriesCapability.deleteExpiredTemporaryFileEntries();
        }
    }

    protected void deleteFolders(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteFolderIds = null;
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        deleteFolderIds = folderId > 0L ? new long[]{folderId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFolder");
        ArrayList<DLFolder> trashedModels = new ArrayList<DLFolder>();
        for (long deleteFolderId : deleteFolderIds) {
            if (moveToTrash) {
                Folder folder = this._dlTrashService.moveFolderToTrash(deleteFolderId);
                if (!(folder.getModel() instanceof DLFolder)) continue;
                trashedModels.add((DLFolder)folder.getModel());
                continue;
            }
            this._dlAppService.deleteFolder(deleteFolderId);
        }
        if (moveToTrash && deleteFolderIds.length > 0) {
            HashMap<String, ArrayList<DLFolder>> data = new HashMap<String, ArrayList<DLFolder>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFolder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFolders(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFolders(actionRequest, true);
            } else if (cmd.equals("subscribe")) {
                this.subscribeFolder(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeFolder(actionRequest);
            } else if (cmd.equals("deleteExpiredTemporaryFileEntries")) {
                this.deleteExpiredTemporaryFileEntries(actionRequest);
            } else if (cmd.equals("updateWorkflowDefinitions")) {
                this.updateWorkflowDefinitions(actionRequest);
            }
        }
        catch (NoSuchFolderException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/document_library/error.jsp");
        }
        catch (DuplicateFileEntryException | DuplicateFileException | DuplicateFolderNameException | FolderNameException | RequiredFileEntryTypeException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    protected void setDLTrashService(DLTrashService dlTrashService) {
        this._dlTrashService = dlTrashService;
    }

    protected void subscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        this._dlAppService.subscribeFolder(themeDisplay.getScopeGroupId(), folderId);
    }

    protected void unsubscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        this._dlAppService.unsubscribeFolder(themeDisplay.getScopeGroupId(), folderId);
    }

    protected void updateFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
            long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
            this._dlAppService.addFolder(repositoryId, parentFolderId, name, description, serviceContext);
        } else {
            this._dlAppService.updateFolder(folderId, name, description, serviceContext);
        }
    }

    protected void updateWorkflowDefinitions(ActionRequest actionRequest) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        this._dlAppService.updateFolder(0L, null, null, serviceContext);
    }
}

