/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context.logic;

import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.web.internal.security.permission.resource.DLFileShortcutPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;

public class FileShortcutDisplayContextHelper {
    private Boolean _dlFileShortcut;
    private final FileShortcut _fileShortcut;
    private Boolean _hasDeletePermission;
    private Boolean _hasExportImportPermission;
    private Boolean _hasPermissionsPermission;
    private Boolean _hasUpdatePermission;
    private final PermissionChecker _permissionChecker;

    public FileShortcutDisplayContextHelper(PermissionChecker permissionChecker, FileShortcut fileShortcut) {
        this._permissionChecker = permissionChecker;
        this._fileShortcut = fileShortcut;
        if (this._fileShortcut == null) {
            this._setValuesForNullFileShortcut();
        }
    }

    public boolean hasDeletePermission() throws PortalException {
        if (this._hasDeletePermission == null) {
            this._hasDeletePermission = DLFileShortcutPermission.contains(this._permissionChecker, this._fileShortcut, "DELETE");
        }
        return this._hasDeletePermission;
    }

    public boolean hasExportImportPermission() throws PortalException {
        if (this._hasExportImportPermission == null) {
            this._hasExportImportPermission = GroupPermissionUtil.contains((PermissionChecker)this._permissionChecker, (long)this._fileShortcut.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        }
        return this._hasExportImportPermission;
    }

    public boolean hasPermissionsPermission() throws PortalException {
        if (this._hasPermissionsPermission == null) {
            this._hasPermissionsPermission = DLFileShortcutPermission.contains(this._permissionChecker, this._fileShortcut, "PERMISSIONS");
        }
        return this._hasPermissionsPermission;
    }

    public boolean hasUpdatePermission() throws PortalException {
        if (this._hasUpdatePermission == null) {
            this._hasUpdatePermission = DLFileShortcutPermission.contains(this._permissionChecker, this._fileShortcut, "UPDATE");
        }
        return this._hasUpdatePermission;
    }

    public boolean isDLFileShortcut() {
        if (this._dlFileShortcut == null) {
            this._dlFileShortcut = this._fileShortcut.getModel() instanceof DLFileShortcut ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this._dlFileShortcut;
    }

    public boolean isEditActionAvailable() throws PortalException {
        return this.isUpdatable();
    }

    public boolean isFileShortcutDeletable() throws PortalException {
        return this.hasDeletePermission();
    }

    public boolean isMoveActionAvailable() throws PortalException {
        return this.isUpdatable();
    }

    public boolean isPermissionsButtonVisible() throws PortalException {
        return this.hasPermissionsPermission();
    }

    public boolean isUpdatable() throws PortalException {
        return this.hasUpdatePermission();
    }

    private void _setValuesForNullFileShortcut() {
        this._hasDeletePermission = false;
        this._hasExportImportPermission = false;
        this._hasPermissionsPermission = false;
        this._hasUpdatePermission = false;
    }
}

