/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context;

import com.liferay.document.library.web.internal.display.context.util.DLRequestHelper;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DLAdminNavigationDisplayContext {
    private final PortletURL _currentURLObj;
    private final DLRequestHelper _dlRequestHelper;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final HttpServletRequest _request;
    private final ThemeDisplay _themeDisplay;

    public DLAdminNavigationDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)liferayPortletRequest, (LiferayPortletResponse)liferayPortletResponse);
        this._request = liferayPortletRequest.getHttpServletRequest();
        this._dlRequestHelper = new DLRequestHelper(this._request);
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<NavigationItem> getNavigationItems() {
        final String mvcRenderCommandName = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"mvcRenderCommandName", (String)"/document_library/view");
        return new NavigationItemList(){
            {
                this.add(navigationItem -> DLAdminNavigationDisplayContext.this._populateDocumentLibraryNavigationItem(navigationItem, mvcRenderCommandName));
                if ("com_liferay_document_library_web_portlet_DLAdminPortlet".equals(DLAdminNavigationDisplayContext.this._dlRequestHelper.getPortletName())) {
                    this.add(navigationItem -> DLAdminNavigationDisplayContext.this._populateFileEntryTypesNavigationItem(navigationItem, mvcRenderCommandName));
                    this.add(x$0 -> DLAdminNavigationDisplayContext.this._populateMetadataSetsNavigationItem(x$0));
                }
            }
        };
    }

    private Portlet _getPortlet(ThemeDisplay themeDisplay) {
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return PortletLocalServiceUtil.getPortletById((String)portletDisplay.getId());
    }

    private void _populateDocumentLibraryNavigationItem(NavigationItem navigationItem, String mvcRenderCommandName) {
        navigationItem.setActive(!mvcRenderCommandName.equals("/document_library/view_file_entry_types"));
        PortletURL viewDocumentLibraryURL = this._liferayPortletResponse.createRenderURL();
        viewDocumentLibraryURL.setParameter("mvcRenderCommandName", "/document_library/view");
        viewDocumentLibraryURL.setParameter("redirect", this._currentURLObj.toString());
        navigationItem.setHref((Object)viewDocumentLibraryURL.toString());
        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._liferayPortletRequest.getHttpServletRequest(), (String)"documents-and-media"));
    }

    private void _populateFileEntryTypesNavigationItem(NavigationItem navigationItem, String mvcRenderCommandName) {
        navigationItem.setActive(mvcRenderCommandName.equals("/document_library/view_file_entry_types"));
        PortletURL viewFileEntryTypesURL = this._liferayPortletResponse.createRenderURL();
        viewFileEntryTypesURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry_types");
        viewFileEntryTypesURL.setParameter("redirect", this._currentURLObj.toString());
        navigationItem.setHref((Object)viewFileEntryTypesURL.toString());
        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._liferayPortletRequest.getHttpServletRequest(), (String)"document-types"));
    }

    private void _populateMetadataSetsNavigationItem(NavigationItem navigationItem) {
        navigationItem.setActive(false);
        Portlet portlet = this._getPortlet(this._themeDisplay);
        LiferayPortletURL viewMetadataSetsURL = PortletURLFactoryUtil.create((PortletRequest)this._liferayPortletRequest, (String)PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW), (String)"RENDER_PHASE");
        viewMetadataSetsURL.setParameter("mvcPath", "/view.jsp");
        viewMetadataSetsURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        viewMetadataSetsURL.setParameter("groupId", String.valueOf(this._themeDisplay.getScopeGroupId()));
        viewMetadataSetsURL.setParameter("refererPortletName", "com_liferay_document_library_web_portlet_DLPortlet");
        viewMetadataSetsURL.setParameter("refererWebDAVToken", WebDAVUtil.getStorageToken((Portlet)portlet));
        viewMetadataSetsURL.setParameter("showAncestorScopes", Boolean.TRUE.toString());
        viewMetadataSetsURL.setParameter("showManageTemplates", Boolean.FALSE.toString());
        navigationItem.setHref((Object)viewMetadataSetsURL.toString());
        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._liferayPortletRequest.getHttpServletRequest(), (String)"metadata-sets"));
    }
}

