/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.webdav;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLTrashService;
import com.liferay.document.library.web.internal.util.DLTrashUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.InvalidLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.NoSuchLockException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.Status;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.webdav.LockException;
import com.liferay.portlet.documentlibrary.webdav.DLFileEntryResourceImpl;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "webdav.storage.token=document_library"}, service={WebDAVStorage.class})
public class DLWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public static final String MS_OFFICE_2010_TEXT_XML_UTF8 = "text/xml; charset=\"utf-8\"";
    private static final Log _log = LogFactoryUtil.getLog(DLWebDAVStorageImpl.class);
    private AssetCategoryLocalService _assetCategoryLocalService;
    private AssetEntryLocalService _assetEntryLocalService;
    private AssetLinkLocalService _assetLinkLocalService;
    private AssetTagLocalService _assetTagLocalService;
    private DLAppService _dlAppService;
    private DLTrashService _dlTrashService;

    public int copyCollectionResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite, long depth) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long companyId = webDAVRequest.getCompanyId();
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(companyId, destinationArray);
            }
            catch (NoSuchFolderException nsfe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsfe, (Throwable)nsfe);
                }
                return 409;
            }
            Folder folder = (Folder)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String)destination);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDAVRequest.getLockUuid())) {
                status = 204;
            }
            if (depth == 0L) {
                this._dlAppService.addFolder(groupId, parentFolderId, name, description, serviceContext);
            } else {
                this._dlAppService.copyFolder(groupId, folder.getFolderId(), parentFolderId, name, description, serviceContext);
            }
            return status;
        }
        catch (DuplicateFolderNameException dfne) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)dfne, (Throwable)dfne);
            }
            return 412;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int copySimpleResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        int n;
        File file = null;
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long companyId = webDAVRequest.getCompanyId();
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(companyId, destinationArray);
            }
            catch (NoSuchFolderException nsfe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsfe, (Throwable)nsfe);
                }
                int n2 = 409;
                FileUtil.delete(file);
                return n2;
            }
            FileEntry fileEntry = (FileEntry)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String)destination);
            String mimeType = fileEntry.getMimeType();
            String title = this.getTitle(destinationArray);
            String description = fileEntry.getDescription();
            String changeLog = "";
            InputStream is = fileEntry.getContentStream();
            file = FileUtil.createTempFile((InputStream)is);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, title, webDAVRequest.getLockUuid())) {
                status = 204;
            }
            this._dlAppService.addFileEntry(groupId, parentFolderId, title, mimeType, title, description, changeLog, file, serviceContext);
            n = status;
            FileUtil.delete((File)file);
        }
        catch (DuplicateFileEntryException dfee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)dfee, (Throwable)dfee);
            }
            int n3 = 412;
            return n3;
        }
        catch (DuplicateFolderNameException dfne) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)dfne, (Throwable)dfne);
            }
            int n4 = 412;
            return n4;
        }
        catch (LockException le) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)le, (Throwable)le);
            }
            int n5 = 423;
            return n5;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            int n6 = 403;
            return n6;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        finally {
            FileUtil.delete(file);
        }
        return n;
    }

    public int deleteResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            Resource resource = this.getResource(webDAVRequest);
            if (resource == null) {
                if (webDAVRequest.isAppleDoubleRequest()) {
                    return 204;
                }
                return 404;
            }
            Object model = resource.getModel();
            if (model instanceof Folder) {
                Folder folder = (Folder)model;
                long folderId = folder.getFolderId();
                if (folder.getModel() instanceof DLFolder && DLTrashUtil.isTrashEnabled(folder.getGroupId(), folder.getRepositoryId())) {
                    this._dlTrashService.moveFolderToTrash(folderId);
                } else {
                    this._dlAppService.deleteFolder(folderId);
                }
            } else {
                FileEntry fileEntry = (FileEntry)model;
                if (!this.hasLock(fileEntry, webDAVRequest.getLockUuid()) && fileEntry.getLock() != null) {
                    return 423;
                }
                long fileEntryId = fileEntry.getFileEntryId();
                if (fileEntry.getModel() instanceof DLFileEntry && DLTrashUtil.isTrashEnabled(fileEntry.getGroupId(), fileEntry.getRepositoryId())) {
                    this._dlTrashService.moveFileEntryToTrash(fileEntryId);
                } else {
                    this._dlAppService.deleteFileEntry(fileEntryId);
                }
            }
            return 204;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            String[] pathArray = webDAVRequest.getPathArray();
            long companyId = webDAVRequest.getCompanyId();
            long parentFolderId = this.getParentFolderId(companyId, pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            if (Validator.isNull((String)name)) {
                String path = this.getRootPath() + webDAVRequest.getPath();
                return new BaseResourceImpl(path, "", this.getToken());
            }
            try {
                Folder folder = this._dlAppService.getFolder(webDAVRequest.getGroupId(), parentFolderId, name);
                if (folder.getParentFolderId() != parentFolderId || webDAVRequest.getGroupId() != folder.getRepositoryId()) {
                    StringBundler sb = new StringBundler(6);
                    sb.append("No DLFolder exists with the key ");
                    sb.append("{parendFolderId=");
                    sb.append(parentFolderId);
                    sb.append(", repositoryId=");
                    sb.append(webDAVRequest.getGroupId());
                    sb.append("}");
                    throw new NoSuchFolderException(sb.toString());
                }
                return this.toResource(webDAVRequest, folder, false);
            }
            catch (NoSuchFolderException nsfe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsfe, (Throwable)nsfe);
                }
                try {
                    String title = this.getTitle(pathArray);
                    FileEntry fileEntry = this._dlAppService.getFileEntry(webDAVRequest.getGroupId(), parentFolderId, title);
                    return this.toResource(webDAVRequest, fileEntry, false);
                }
                catch (NoSuchFileEntryException nsfee) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)nsfee, (Throwable)nsfee);
                    }
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            long folderId = this.getFolderId(webDAVRequest.getCompanyId(), webDAVRequest.getPathArray());
            List<Resource> folders = this.getFolders(webDAVRequest, folderId);
            List<Resource> fileEntries = this.getFileEntries(webDAVRequest, folderId);
            ArrayList<Resource> resources = new ArrayList<Resource>(folders.size() + fileEntries.size());
            resources.addAll(folders);
            resources.addAll(fileEntries);
            return resources;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public boolean isSupportsClassTwo() {
        return true;
    }

    public Status lockResource(WebDAVRequest webDAVRequest, String owner, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDAVRequest);
        Lock lock = null;
        int status = 200;
        try {
            if (resource == null) {
                status = 201;
                HttpServletRequest request = webDAVRequest.getHttpServletRequest();
                String[] pathArray = webDAVRequest.getPathArray();
                long companyId = webDAVRequest.getCompanyId();
                long groupId = webDAVRequest.getGroupId();
                long parentFolderId = this.getParentFolderId(companyId, pathArray);
                String title = this.getTitle(pathArray);
                String extension = FileUtil.getExtension((String)title);
                String contentType = this.getContentType(request, null, title, extension);
                String description = "";
                String changeLog = "";
                File file = FileUtil.createTempFile((String)extension);
                file.createNewFile();
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
                serviceContext.setAddGuestPermissions(true);
                FileEntry fileEntry = this._dlAppService.addFileEntry(groupId, parentFolderId, title, contentType, title, description, changeLog, file, serviceContext);
                resource = this.toResource(webDAVRequest, fileEntry, false);
            }
            if (resource instanceof DLFileEntryResourceImpl) {
                FileEntry fileEntry = (FileEntry)resource.getModel();
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAttribute("manualCheckInRequired", (Serializable)Boolean.valueOf(webDAVRequest.isManualCheckInRequired()));
                this._dlAppService.checkOutFileEntry(fileEntry.getFileEntryId(), owner, timeout, serviceContext);
                lock = fileEntry.getLock();
            } else {
                boolean inheritable = false;
                long depth = WebDAVUtil.getDepth((HttpServletRequest)webDAVRequest.getHttpServletRequest());
                if (depth != 0L) {
                    inheritable = true;
                }
                Folder folder = (Folder)resource.getModel();
                lock = this._dlAppService.lockFolder(folder.getRepositoryId(), folder.getFolderId(), owner, inheritable, timeout);
            }
        }
        catch (Exception e) {
            if (!(e instanceof DuplicateLockException)) {
                throw new WebDAVException((Throwable)e);
            }
            status = 423;
        }
        return new Status(lock, status);
    }

    public Status makeCollection(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            HttpServletRequest request = webDAVRequest.getHttpServletRequest();
            if (request.getContentLength() > 0) {
                return new Status(415);
            }
            Object[] pathArray = webDAVRequest.getPathArray();
            long companyId = webDAVRequest.getCompanyId();
            long groupId = webDAVRequest.getGroupId();
            long parentFolderId = this.getParentFolderId(companyId, (String[])pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            this._dlAppService.addFolder(groupId, parentFolderId, name, description, serviceContext);
            String location = StringUtil.merge((Object[])pathArray, (String)"/");
            return new Status((Object)location, 201);
        }
        catch (DuplicateFolderNameException dfne) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)dfne, (Throwable)dfne);
            }
            return new Status(405);
        }
        catch (DuplicateFileEntryException dfee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)dfee, (Throwable)dfee);
            }
            return new Status(405);
        }
        catch (NoSuchFolderException nsfe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfe, (Throwable)nsfe);
            }
            return new Status(409);
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return new Status(403);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int moveCollectionResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            Folder folder = (Folder)resource.getModel();
            long companyId = webDAVRequest.getCompanyId();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])destinationArray);
            long folderId = folder.getFolderId();
            long parentFolderId = this.getParentFolderId(companyId, destinationArray);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setUserId(webDAVRequest.getUserId());
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDAVRequest.getLockUuid())) {
                status = 204;
            }
            if (parentFolderId != folder.getParentFolderId()) {
                this._dlAppService.moveFolder(folderId, parentFolderId, serviceContext);
            }
            if (!name.equals(folder.getName())) {
                this._dlAppService.updateFolder(folderId, name, description, serviceContext);
            }
            return status;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 403;
        }
        catch (DuplicateFolderNameException dfne) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)dfne, (Throwable)dfne);
            }
            return 412;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public int moveSimpleResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int putResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Lock refreshResourceLock(WebDAVRequest webDAVRequest, String uuid, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDAVRequest);
        long companyId = webDAVRequest.getCompanyId();
        Lock lock = null;
        try {
            lock = resource instanceof DLFileEntryResourceImpl ? this._dlAppService.refreshFileEntryLock(uuid, companyId, timeout) : this._dlAppService.refreshFolderLock(uuid, companyId, timeout);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        return lock;
    }

    public boolean unlockResource(WebDAVRequest webDAVRequest, String token) throws WebDAVException {
        block8: {
            Resource resource = this.getResource(webDAVRequest);
            try {
                if (resource instanceof DLFileEntryResourceImpl) {
                    FileEntry fileEntry = (FileEntry)resource.getModel();
                    if (fileEntry.isManualCheckInRequired()) {
                        return false;
                    }
                    ServiceContext serviceContext = new ServiceContext();
                    serviceContext.setAttribute("webDAVCheckInMode", (Serializable)Boolean.valueOf(true));
                    this._dlAppService.checkInFileEntry(fileEntry.getFileEntryId(), token, serviceContext);
                    if (webDAVRequest.isAppleDoubleRequest()) {
                        this._dlAppService.deleteFileEntry(fileEntry.getFileEntryId());
                    }
                } else {
                    Folder folder = (Folder)resource.getModel();
                    this._dlAppService.unlockFolder(folder.getRepositoryId(), folder.getParentFolderId(), folder.getName(), token);
                }
                return true;
            }
            catch (InvalidLockException ile) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)ile.getMessage());
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)"Unable to unlock file entry", (Throwable)e);
            }
        }
        return false;
    }

    protected boolean deleteResource(long groupId, long parentFolderId, String name, String lockUuid) throws Exception {
        try {
            Folder folder = this._dlAppService.getFolder(groupId, parentFolderId, name);
            this._dlAppService.deleteFolder(folder.getFolderId());
            return true;
        }
        catch (NoSuchFolderException nsfe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfe, (Throwable)nsfe);
            }
            try {
                FileEntry fileEntry = this._dlAppService.getFileEntry(groupId, parentFolderId, name);
                if (!this.hasLock(fileEntry, lockUuid) && fileEntry.getLock() != null) {
                    StringBundler sb = new StringBundler(4);
                    sb.append("Inconsistent file lock state for file entry ");
                    sb.append(fileEntry.getPrimaryKey());
                    sb.append(" and lock UUID ");
                    sb.append(lockUuid);
                    throw new LockException(sb.toString());
                }
                this._dlAppService.deleteFileEntryByTitle(groupId, parentFolderId, name);
                return true;
            }
            catch (NoSuchFileEntryException nsfee) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsfee, (Throwable)nsfee);
                }
                return false;
            }
        }
    }

    protected String getContentType(HttpServletRequest request, File file, String title, String extension) {
        String contentType = GetterUtil.getString((String)request.getHeader("Content-Type"), (String)"application/octet-stream");
        if (contentType.equals("application/octet-stream") || contentType.equals(MS_OFFICE_2010_TEXT_XML_UTF8)) {
            contentType = MimeTypesUtil.getContentType((File)file, (String)title);
        }
        return contentType;
    }

    protected List<Resource> getFileEntries(WebDAVRequest webDAVRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List fileEntries = this._dlAppService.getFileEntries(webDAVRequest.getGroupId(), parentFolderId);
        for (FileEntry fileEntry : fileEntries) {
            if (!DLWebDAVUtil.isRepresentableTitle((String)fileEntry.getTitle())) {
                _log.error((Object)("Unrepresentable WebDAV title for file name " + fileEntry.getTitle()));
                continue;
            }
            Resource resource = this.toResource(webDAVRequest, fileEntry, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getFolderId(long companyId, String[] pathArray) throws Exception {
        return this.getFolderId(companyId, pathArray, false);
    }

    protected long getFolderId(long companyId, String[] pathArray, boolean parent) throws Exception {
        long folderId = 0L;
        if (pathArray.length <= 1) {
            return folderId;
        }
        long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])pathArray);
        int x = pathArray.length;
        if (parent) {
            --x;
        }
        for (int i = 2; i < x; ++i) {
            String name = pathArray[i];
            Folder folder = this._dlAppService.getFolder(groupId, folderId, name);
            if (groupId != folder.getRepositoryId()) continue;
            folderId = folder.getFolderId();
        }
        return folderId;
    }

    protected List<Resource> getFolders(WebDAVRequest webDAVRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        long groupId = webDAVRequest.getGroupId();
        List folders = this._dlAppService.getFolders(groupId, parentFolderId, false);
        for (Folder folder : folders) {
            Resource resource = this.toResource(webDAVRequest, folder, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getParentFolderId(long companyId, String[] pathArray) throws Exception {
        return this.getFolderId(companyId, pathArray, true);
    }

    protected String getTitle(String[] pathArray) {
        return DLWebDAVUtil.unescapeRawTitle((String)WebDAVUtil.getResourceName((String[])pathArray));
    }

    protected boolean hasLock(FileEntry fileEntry, String lockUuid) throws Exception {
        if (Validator.isNull((String)lockUuid)) {
            return fileEntry.hasLock();
        }
        try {
            return this._dlAppService.verifyFileEntryLock(fileEntry.getRepositoryId(), fileEntry.getFileEntryId(), lockUuid);
        }
        catch (NoSuchLockException nsle) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsle, (Throwable)nsle);
            }
            return false;
        }
    }

    protected void populateServiceContext(ServiceContext serviceContext, FileEntry fileEntry) {
        String className = DLFileEntryConstants.getClassName();
        long[] assetCategoryIds = this._assetCategoryLocalService.getCategoryIds(className, fileEntry.getFileEntryId());
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(className, fileEntry.getFileEntryId());
        List assetLinks = this._assetLinkLocalService.getLinks(assetEntry.getEntryId());
        long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        serviceContext.setAssetLinkEntryIds(assetLinkEntryIds);
        String[] assetTagNames = this._assetTagLocalService.getTagNames(className, fileEntry.getFileEntryId());
        serviceContext.setAssetTagNames(assetTagNames);
        ExpandoBridge expandoBridge = fileEntry.getExpandoBridge();
        serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
    }

    @Reference(unbind="-")
    protected void setAssetCategoryLocalService(AssetCategoryLocalService assetCategoryLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setAssetLinkLocalService(AssetLinkLocalService assetLinkLocalService) {
        this._assetLinkLocalService = assetLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setAssetTagLocalService(AssetTagLocalService assetTagLocalService) {
        this._assetTagLocalService = assetTagLocalService;
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    protected void setDLTrashService(DLTrashService dlTrashService) {
        this._dlTrashService = dlTrashService;
    }

    protected Resource toResource(WebDAVRequest webDAVRequest, FileEntry fileEntry, boolean appendPath) {
        return new DLFileEntryResourceImpl(webDAVRequest, fileEntry, appendPath);
    }

    protected Resource toResource(WebDAVRequest webDAVRequest, Folder folder, boolean appendPath) {
        String parentPath = this.getRootPath() + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = folder.getName();
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, folder.getName(), folder.getCreateDate(), folder.getModifiedDate());
        resource.setModel((Object)folder);
        resource.setClassName(Folder.class.getName());
        resource.setPrimaryKey(folder.getPrimaryKey());
        return resource;
    }
}

