/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.social;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.web.internal.util.DLResourceBundleLoader;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.trash.kernel.util.TrashUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet"}, service={SocialActivityInterpreter.class})
public class DLFileEntryActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{DLFileEntry.class.getName()};
    private DLAppLocalService _dlAppLocalService;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getBody(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        FileEntry fileEntry = this._dlAppLocalService.getFileEntry(activity.getClassPK());
        if (TrashUtil.isInTrash((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId())) {
            return "";
        }
        StringBundler sb = new StringBundler(3);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)DLFileEntry.class.getName());
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(fileEntry.getFileEntryId());
        String fileEntryLink = assetRenderer.getURLDownload(serviceContext.getThemeDisplay());
        sb.append(this.wrapLink(fileEntryLink, "download-file", serviceContext));
        sb.append(" ");
        String folderLink = this.getFolderLink(fileEntry, serviceContext);
        folderLink = this.addNoSuchEntryRedirect(folderLink, DLFolder.class.getName(), fileEntry.getFolderId(), serviceContext);
        sb.append(this.wrapLink(folderLink, "go-to-folder", serviceContext));
        return sb.toString();
    }

    protected String getFolderLink(FileEntry fileEntry, ServiceContext serviceContext) {
        StringBundler sb = new StringBundler(6);
        sb.append(serviceContext.getPortalURL());
        sb.append(serviceContext.getPathMain());
        sb.append("/document_library/find_folder?groupId=");
        sb.append(fileEntry.getRepositoryId());
        sb.append("&folderId=");
        sb.append(fileEntry.getFolderId());
        return sb.toString();
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/document_library/find_file_entry?fileEntryId=" + activity.getClassPK();
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return DLResourceBundleLoader.INSTANCE;
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-document-library-file-add-file";
            }
            return "activity-document-library-file-add-file-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-document-library-file-update-file";
            }
            return "activity-document-library-file-update-file-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-document-library-file-move-to-trash";
            }
            return "activity-document-library-file-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-document-library-file-restore-from-trash";
            }
            return "activity-document-library-file-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return DLFileEntryPermission.contains((PermissionChecker)permissionChecker, (long)activity.getClassPK(), (String)actionId);
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }
}

