/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.upload;

import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.BaseUploadHandler;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;

public class FileEntryDLUploadHandler
extends BaseUploadHandler {
    private static final Log _log = LogFactoryUtil.getLog(FileEntryDLUploadHandler.class);

    protected FileEntry addFileEntry(long userId, long groupId, long folderId, String fileName, String contentType, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        return DLAppServiceUtil.addFileEntry((long)groupId, (long)folderId, (String)fileName, (String)contentType, (String)fileName, (String)"", (String)"", (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
    }

    protected void checkPermission(long groupId, long folderId, PermissionChecker permissionChecker) throws PortalException {
        DLFolderPermission.check((PermissionChecker)permissionChecker, (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
    }

    protected FileEntry fetchFileEntry(long userId, long groupId, long folderId, String fileName) throws PortalException {
        try {
            return DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
        }
        catch (PortalException pe) {
            return null;
        }
    }

    protected long getFolderId(UploadPortletRequest uploadPortletRequest) {
        return ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
    }

    protected String getParameterName() {
        return "imageSelectorFileName";
    }

    protected ServiceContext getServiceContext(UploadPortletRequest uploadPortletRequest) throws PortalException {
        return ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (UploadPortletRequest)uploadPortletRequest);
    }

    protected String getURL(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        try {
            return DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getLatestFileVersion(), (ThemeDisplay)themeDisplay, (String)"");
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get URL for file entry " + fileEntry.getFileEntryId()));
            }
            return "";
        }
    }

    protected void validateFile(String fileName, String contentType, long size) throws PortalException {
        long maxSize = PrefsPropsUtil.getLong((String)"dl.file.max.size");
        if (maxSize > 0L && size > maxSize) {
            throw new FileSizeException(size + " exceeds its maximum permitted size of " + maxSize);
        }
    }
}

