/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.toolbar.contributor.helper;

import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.web.internal.settings.DLPortletInstanceSettings;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLPortletToolbarContributorHelper.class})
public class DLPortletToolbarContributorHelper {
    private static final Log _log = LogFactoryUtil.getLog(DLPortletToolbarContributorHelper.class);
    private DLAppLocalService _dlAppLocalService;

    public Folder getFolder(ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        Folder folder = (Folder)portletRequest.getAttribute("DOCUMENT_LIBRARY_FOLDER");
        if (folder != null) {
            return folder;
        }
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        long rootFolderId = 0L;
        try {
            DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
            rootFolderId = dlPortletInstanceSettings.getRootFolderId();
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        if (rootFolderId != 0L) {
            try {
                folder = this._dlAppLocalService.getFolder(rootFolderId);
            }
            catch (NoSuchFolderException nsfe) {
                folder = null;
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return folder;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }
}

