/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/edit_folder"}, service={MVCResourceCommand.class})
public class EditFolderMVCResourceCommand
implements MVCResourceCommand {
    private DLAppService _dlAppService;

    public boolean serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            this.downloadFolder(resourceRequest, resourceResponse);
            return true;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadFolder(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"folderId");
        File file = null;
        FileInputStream inputStream = null;
        try {
            String zipFileName = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"documents-and-media");
            if (folderId != 0L) {
                Folder folder = this._dlAppService.getFolder(folderId);
                zipFileName = folder.getName();
            }
            ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
            this.zipFolder(repositoryId, folderId, "/", zipWriter);
            file = zipWriter.getFile();
            inputStream = new FileInputStream(file);
            PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)zipFileName, (InputStream)inputStream, (String)"application/zip");
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            if (file != null) {
                file.delete();
            }
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        if (file != null) {
            file.delete();
        }
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    protected void zipFolder(long repositoryId, long folderId, String path, ZipWriter zipWriter) throws Exception {
        List foldersAndFileEntriesAndFileShortcuts = this._dlAppService.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, 0, false, -1, -1);
        for (Object entry : foldersAndFileEntriesAndFileShortcuts) {
            if (entry instanceof Folder) {
                Folder folder = (Folder)entry;
                this.zipFolder(folder.getRepositoryId(), folder.getFolderId(), path.concat("/").concat(folder.getName()), zipWriter);
                continue;
            }
            if (!(entry instanceof FileEntry)) continue;
            FileEntry fileEntry = (FileEntry)entry;
            zipWriter.addEntry(path + "/" + HtmlUtil.escapeURL((String)fileEntry.getTitle()), fileEntry.getContentStream());
        }
    }
}

