/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.InvalidFolderException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.SourceFileNameException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLTrashService;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.kernel.service.TrashEntryService;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/edit_entry", "mvc.command.name=/document_library/move_entry"}, service={MVCActionCommand.class})
public class EditEntryMVCActionCommand
extends BaseMVCActionCommand {
    private DLAppService _dlAppService;
    private DLTrashService _dlTrashService;
    private TrashEntryService _trashEntryService;

    protected void cancelCheckedOutEntries(ActionRequest actionRequest) throws Exception {
        long[] fileEntryIds;
        for (long fileEntryId : fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry")) {
            this._dlAppService.cancelCheckOut(fileEntryId);
        }
    }

    protected void checkInEntries(ActionRequest actionRequest) throws Exception {
        long[] fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        for (long fileEntryId : fileEntryIds) {
            this._dlAppService.checkInFileEntry(fileEntryId, false, "", serviceContext);
        }
    }

    protected void checkOutEntries(ActionRequest actionRequest) throws Exception {
        long[] fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        for (long fileEntryId : fileEntryIds) {
            this._dlAppService.checkOutFileEntry(fileEntryId, serviceContext);
        }
    }

    protected void deleteEntries(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteFileEntryIds;
        long[] deleteFolderIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFolder");
        ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>();
        for (int i = 0; i < deleteFolderIds.length; ++i) {
            long deleteFolderId = deleteFolderIds[i];
            if (moveToTrash) {
                Folder folder = this._dlTrashService.moveFolderToTrash(deleteFolderId);
                if (!(folder.getModel() instanceof TrashedModel)) continue;
                trashedModels.add((TrashedModel)folder.getModel());
                continue;
            }
            this._dlAppService.deleteFolder(deleteFolderId);
        }
        long[] deleteFileShortcutIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsDLFileShortcut");
        for (int i = 0; i < deleteFileShortcutIds.length; ++i) {
            long deleteFileShortcutId = deleteFileShortcutIds[i];
            if (moveToTrash) {
                FileShortcut fileShortcut = this._dlTrashService.moveFileShortcutToTrash(deleteFileShortcutId);
                if (!(fileShortcut.getModel() instanceof TrashedModel)) continue;
                trashedModels.add((TrashedModel)fileShortcut.getModel());
                continue;
            }
            this._dlAppService.deleteFileShortcut(deleteFileShortcutId);
        }
        for (long deleteFileEntryId : deleteFileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry")) {
            if (moveToTrash) {
                FileEntry fileEntry = this._dlTrashService.moveFileEntryToTrash(deleteFileEntryId);
                if (!(fileEntry.getModel() instanceof TrashedModel)) continue;
                trashedModels.add((TrashedModel)fileEntry.getModel());
                continue;
            }
            this._dlAppService.deleteFileEntry(deleteFileEntryId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            String redirect;
            if (cmd.equals("cancel_checkout")) {
                this.cancelCheckedOutEntries(actionRequest);
            } else if (cmd.equals("checkin")) {
                this.checkInEntries(actionRequest);
            } else if (cmd.equals("checkout")) {
                this.checkOutEntries(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest, false);
            } else if (cmd.equals("move")) {
                this.moveEntries(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntries(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (windowState.equals((Object)LiferayWindowState.POP_UP) && Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (NoSuchFileEntryException | NoSuchFolderException | DuplicateLockException | PrincipalException e) {
            if (e instanceof DuplicateLockException) {
                DuplicateLockException dle = (DuplicateLockException)e;
                SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)dle)).getClass(), (Object)dle.getLock());
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            actionResponse.setRenderParameter("mvcPath", "/document_library/error.jsp");
        }
        catch (DuplicateFileEntryException | DuplicateFolderNameException | SourceFileNameException e) {
            if (e instanceof DuplicateFileEntryException) {
                HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                response.setStatus(490);
            }
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
        }
        catch (AssetCategoryException | AssetTagException | InvalidFolderException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void moveEntries(ActionRequest actionRequest) throws Exception {
        long[] fileShortcutIds;
        long[] fileEntryIds;
        long[] folderIds;
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        for (long folderId : folderIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFolder")) {
            this._dlAppService.moveFolder(folderId, newFolderId, serviceContext);
        }
        for (long fileEntryId : fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry")) {
            this._dlAppService.moveFileEntry(fileEntryId, newFolderId, serviceContext);
        }
        for (long fileShortcutId : fileShortcutIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsDLFileShortcut")) {
            if (fileShortcutId == 0L) continue;
            FileShortcut fileShortcut = this._dlAppService.getFileShortcut(fileShortcutId);
            this._dlAppService.updateFileShortcut(fileShortcutId, newFolderId, fileShortcut.getToFileEntryId(), serviceContext);
        }
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    protected void setDLTrashService(DLTrashService dlTrashService) {
        this._dlTrashService = dlTrashService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }
}

