/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.web.internal.portlet.action.GetFolderMVCRenderCommand;
import com.liferay.document.library.web.internal.portlet.toolbar.contributor.DLPortletToolbarContributor;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "mvc.command.name=/", "mvc.command.name=/document_library/view", "mvc.command.name=/document_library/view_folder"}, service={MVCRenderCommand.class})
public class DLViewMVCRenderCommand
extends GetFolderMVCRenderCommand {
    private DLAppService _dlAppService;
    private DLFolderLocalService _dlFolderLocalService;
    private DLPortletToolbarContributor _dlPortletToolbarContributor;

    @Override
    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        renderRequest.setAttribute("DOCUMENT_LIBRARY_PORTLET_TOOLBAR_CONTRIBUTOR", (Object)this._dlPortletToolbarContributor);
        try {
            this.pingFolderRepository(renderRequest);
        }
        catch (Exception e) {
            SessionErrors.add((PortletRequest)renderRequest, (String)"repositoryPingFailed", (Object)e);
            return "/document_library/error.jsp";
        }
        return super.render(renderRequest, renderResponse);
    }

    @Reference(unbind="-")
    public void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    public void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }

    @Override
    protected String getPath() {
        return "/document_library/view.jsp";
    }

    protected void pingFolderRepository(RenderRequest renderRequest) throws Exception {
        String mvcRenderCommandName = ParamUtil.getString((PortletRequest)renderRequest, (String)"mvcRenderCommandName");
        if (!mvcRenderCommandName.equals("/document_library/view_folder")) {
            return;
        }
        long folderId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"folderId");
        if (folderId == 0L) {
            return;
        }
        DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(folderId);
        if (dlFolder == null || !dlFolder.isMountPoint()) {
            return;
        }
        this._dlAppService.getFileEntriesCount(dlFolder.getRepositoryId(), dlFolder.getFolderId());
    }

    @Reference(unbind="-")
    protected void setDLPortletToolbarContributor(DLPortletToolbarContributor dlPortletToolbarContributor) {
        this._dlPortletToolbarContributor = dlPortletToolbarContributor;
    }
}

