/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.exportimport.lifecycle;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lifecycle.BaseExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ExportImportLifecycleListener.class})
public class CascadeFileEntryTypesExportImportLifecycleListener
extends BaseExportImportLifecycleListener {
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    private DLFolderLocalService _dlFolderLocalService;
    private Map<Long, Long> _importedFolderIds;
    private Set<Long> _processedFolderIds;

    public boolean isParallel() {
        return true;
    }

    protected DLFolder getProcessableRootFolder(DLFolder dlFolder) throws PortalException {
        long dlFolderId = dlFolder.getFolderId();
        if (this._processedFolderIds.contains(dlFolderId)) {
            return null;
        }
        this._processedFolderIds.add(dlFolderId);
        DLFolder parentFolder = dlFolder.getParentFolder();
        if (Validator.isNull((Object)parentFolder) || !this._importedFolderIds.containsValue(parentFolder.getFolderId())) {
            return dlFolder;
        }
        return this.getProcessableRootFolder(parentFolder);
    }

    protected void onLayoutImportProcessFinished(PortletDataContext portletDataContext) throws Exception {
        this._importedFolderIds = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        if (MapUtil.isEmpty(this._importedFolderIds)) {
            return;
        }
        this._processedFolderIds = new HashSet<Long>();
        this.processFolderIds(this._importedFolderIds.values());
    }

    protected void onPortletImportProcessFinished(PortletDataContext portletDataContext) throws Exception {
        this._importedFolderIds = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        if (MapUtil.isEmpty(this._importedFolderIds)) {
            return;
        }
        this._processedFolderIds = new HashSet<Long>();
        this.processFolderIds(this._importedFolderIds.values());
    }

    protected void processFolderIds(Collection<Long> folderIds) throws PortalException {
        for (Long folderId : folderIds) {
            DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(folderId.longValue());
            DLFolder rootFolder = this.getProcessableRootFolder(dlFolder);
            if (!Validator.isNotNull((Object)rootFolder)) continue;
            this._dlFileEntryTypeLocalService.cascadeFileEntryTypes(rootFolder.getUserId(), rootFolder);
        }
    }

    @Reference(unbind="-")
    protected void setDLFileEntryTypeLocalService(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    @Reference(unbind="-")
    protected void setDlFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }
}

