/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context.logic;

import com.liferay.document.library.display.context.DLUIItemKeys;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.web.internal.display.context.logic.FileEntryDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileVersionDisplayContextHelper;
import com.liferay.document.library.web.internal.util.DLTrashUtil;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.language.UnicodeLanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.DeleteMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptUIItem;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLUIItem;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.util.PropsValues;
import com.liferay.taglib.security.PermissionsURLTag;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class UIItemsBuilder {
    private String _currentURL;
    private final FileEntry _fileEntry;
    private final FileEntryDisplayContextHelper _fileEntryDisplayContextHelper;
    private FileShortcut _fileShortcut;
    private final FileVersion _fileVersion;
    private final FileVersionDisplayContextHelper _fileVersionDisplayContextHelper;
    private final long _folderId;
    private Boolean _ieOnWin32;
    private final HttpServletRequest _request;
    private final ThemeDisplay _themeDisplay;
    private Boolean _trashEnabled;

    public UIItemsBuilder(HttpServletRequest request, FileShortcut fileShortcut) throws PortalException {
        this(request, fileShortcut.getFileVersion(), fileShortcut);
    }

    public UIItemsBuilder(HttpServletRequest request, FileVersion fileVersion) {
        this(request, fileVersion, null);
    }

    public void addCancelCheckoutMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCancelCheckoutDocumentActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "cancel_checkout");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.CANCEL_CHECKOUT, "cancel-checkout[document]", portletURL.toString());
    }

    public void addCancelCheckoutToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCancelCheckoutDocumentActionAvailable()) {
            return;
        }
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.CANCEL_CHECKOUT, LanguageUtil.get((HttpServletRequest)this._request, (String)"cancel-checkout[document]"), this.getSubmitFormJavaScript("cancel_checkout", null));
    }

    public void addCheckinMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCheckinActionAvailable()) {
            return;
        }
        menuItems.add((MenuItem)this.getJavacriptCheckinMenuItem());
    }

    public void addCheckinToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCheckinActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "checkin");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        JavaScriptToolbarItem javaScriptToolbarItem = (JavaScriptToolbarItem)this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.CHECKIN, LanguageUtil.get((HttpServletRequest)this._request, (String)"checkin"), this.getNamespace() + "showVersionDetailsDialog('" + portletURL + "');");
        String javaScript = "/com/liferay/document/library/web/display/context/dependencies/checkin_js.ftl";
        Class<?> clazz = this.getClass();
        URLTemplateResource urlTemplateResource = new URLTemplateResource(javaScript, clazz.getResource(javaScript));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        template.put((Object)"dialogTitle", (Object)UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"describe-your-changes"));
        template.put((Object)"namespace", (Object)this.getNamespace());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        javaScriptToolbarItem.setJavaScript(unsyncStringWriter.toString());
    }

    public void addCheckoutMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCheckoutDocumentActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "checkout");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.CHECKOUT, "checkout[document]", portletURL.toString());
    }

    public void addCheckoutToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCheckoutDocumentActionAvailable()) {
            return;
        }
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.CHECKOUT, LanguageUtil.get((HttpServletRequest)this._request, (String)"checkout[document]"), this.getSubmitFormJavaScript("checkout", null));
    }

    public void addDeleteMenuItem(List<MenuItem> menuItems) throws PortalException {
        String cmd = null;
        if (this.isDeleteActionAvailable()) {
            cmd = "delete";
        } else if (this.isMoveToTheRecycleBinActionAvailable()) {
            cmd = "move_to_trash";
        } else {
            return;
        }
        DeleteMenuItem deleteMenuItem = new DeleteMenuItem();
        deleteMenuItem.setKey(DLUIItemKeys.DELETE);
        if (cmd.equals("move_to_trash")) {
            deleteMenuItem.setTrash(true);
        }
        String mvcActionCommandName = "/document_library/edit_file_entry";
        if (this._fileShortcut != null) {
            mvcActionCommandName = "/document_library/edit_file_shortcut";
        }
        PortletURL portletURL = this._getActionURL(mvcActionCommandName, cmd);
        if (this._fileShortcut == null) {
            portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        } else {
            portletURL.setParameter("fileShortcutId", String.valueOf(this._fileShortcut.getFileShortcutId()));
        }
        deleteMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)deleteMenuItem);
    }

    public void addDeleteToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isDeleteActionAvailable()) {
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        long folderId = this._fileEntry.getFolderId();
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        StringBundler sb = new StringBundler(5);
        sb.append("if (confirm('");
        sb.append(UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"are-you-sure-you-want-to-delete-this"));
        sb.append("')) {");
        sb.append(this.getSubmitFormJavaScript("delete", portletURL.toString()));
        sb.append("}");
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.DELETE, LanguageUtil.get((HttpServletRequest)this._request, (String)"delete"), sb.toString());
    }

    public void addDownloadMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isDownloadActionAvailable()) {
            return;
        }
        String label = TextFormatter.formatStorageSize((double)this._fileEntry.getSize(), (Locale)this._themeDisplay.getLocale());
        label = this._themeDisplay.translate("download") + " (" + label + ")";
        String url = DLUtil.getDownloadURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)this._themeDisplay, (String)"", (boolean)false, (boolean)true);
        URLMenuItem urlMenuItem = (URLMenuItem)this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.DOWNLOAD, label, url);
        urlMenuItem.setMethod("get");
        urlMenuItem.setTarget("_blank");
    }

    public void addDownloadToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isDownloadActionAvailable()) {
            return;
        }
        this._addURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems, DLUIItemKeys.DOWNLOAD, LanguageUtil.get((HttpServletRequest)this._request, (String)"download"), DLUtil.getDownloadURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)this._themeDisplay, (String)""));
    }

    public void addEditMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isEditActionAvailable()) {
            return;
        }
        PortletURL portletURL = null;
        portletURL = this._fileShortcut == null ? this._getRenderURL("/document_library/edit_file_entry") : this._getRenderURL("/document_library/edit_file_shortcut");
        portletURL.setParameter("backURL", this._getCurrentURL());
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.EDIT, "edit", portletURL.toString());
    }

    public void addEditToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isEditActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/edit_file_entry");
        this._addURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems, DLUIItemKeys.EDIT, LanguageUtil.get((HttpServletRequest)this._request, (String)"edit"), portletURL.toString());
    }

    public void addMoveMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isMoveActionAvailable()) {
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/document_library/move_entry");
        PortletURL redirectURL = liferayPortletResponse.createRenderURL();
        long folderId = this._fileEntry.getFolderId();
        if (folderId == 0L) {
            redirectURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            redirectURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        redirectURL.setParameter("folderId", String.valueOf(folderId));
        portletURL.setParameter("redirect", redirectURL.toString());
        portletURL.setParameter("rowIdsFileEntry", String.valueOf(this._fileEntry.getFileEntryId()));
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.MOVE, "move", portletURL.toString());
    }

    public void addMoveToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isMoveActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/move_entry");
        this._addURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems, DLUIItemKeys.MOVE, LanguageUtil.get((HttpServletRequest)this._request, (String)"move"), portletURL.toString());
    }

    public void addMoveToTheRecycleBinToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isMoveToTheRecycleBinActionAvailable()) {
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        long folderId = this._fileEntry.getFolderId();
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        portletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.MOVE_TO_THE_RECYCLE_BIN, LanguageUtil.get((HttpServletRequest)this._request, (String)"move-to-the-recycle-bin"), this.getSubmitFormJavaScript("move_to_trash", portletURL.toString()));
    }

    public void addOpenInMsOfficeMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this.isOpenInMsOfficeActionAvailable()) {
            return;
        }
        String webDavURL = DLUtil.getWebDavURL((ThemeDisplay)this._themeDisplay, (Folder)this._fileEntry.getFolder(), (FileEntry)this._fileEntry, (boolean)PropsValues.DL_FILE_ENTRY_OPEN_IN_MS_OFFICE_MANUAL_CHECK_IN_REQUIRED, (boolean)true);
        String onClick = this.getNamespace() + "openDocument('" + webDavURL + "');";
        JavaScriptMenuItem javascriptMenuItem = (JavaScriptMenuItem)this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptMenuItem(), (List)menuItems, DLUIItemKeys.OPEN_IN_MS_OFFICE, "open-in-ms-office", onClick);
        String javaScript = "/com/liferay/document/library/web/display/context/dependencies/open_in_ms_office_js.ftl";
        Class<?> clazz = this.getClass();
        URLTemplateResource urlTemplateResource = new URLTemplateResource(javaScript, clazz.getResource(javaScript));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        template.put((Object)"errorMessage", (Object)UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"cannot-open-the-requested-document-due-to-the-following-reason"));
        template.put((Object)"namespace", (Object)this.getNamespace());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        javascriptMenuItem.setJavaScript(unsyncStringWriter.toString());
    }

    public void addOpenInMsOfficeToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isOpenInMsOfficeActionAvailable()) {
            return;
        }
        String webDavURL = DLUtil.getWebDavURL((ThemeDisplay)this._themeDisplay, (Folder)this._fileEntry.getFolder(), (FileEntry)this._fileEntry, (boolean)PropsValues.DL_FILE_ENTRY_OPEN_IN_MS_OFFICE_MANUAL_CHECK_IN_REQUIRED);
        StringBundler sb = new StringBundler(4);
        sb.append(this.getNamespace());
        sb.append("openDocument('");
        sb.append(webDavURL);
        sb.append("');");
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.OPEN_IN_MS_OFFICE, LanguageUtil.get((HttpServletRequest)this._request, (String)"open-in-ms-office"), sb.toString());
    }

    public void addPermissionsMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isPermissionsButtonVisible()) {
            return;
        }
        String url = null;
        try {
            url = PermissionsURLTag.doTag(null, (String)DLFileEntryConstants.getClassName(), (String)HtmlUtil.unescape((String)this._fileEntry.getTitle()), null, (String)String.valueOf(this._fileEntry.getFileEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._request);
        }
        catch (Exception e) {
            throw new SystemException("Unable to create permissions URL", (Throwable)e);
        }
        URLMenuItem urlMenuItem = (URLMenuItem)this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.PERMISSIONS, "permissions", url);
        urlMenuItem.setMethod("get");
        urlMenuItem.setUseDialog(true);
    }

    public void addPermissionsToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isPermissionsButtonVisible()) {
            return;
        }
        String permissionsURL = null;
        try {
            permissionsURL = PermissionsURLTag.doTag(null, (String)DLFileEntryConstants.getClassName(), (String)HtmlUtil.unescape((String)this._fileEntry.getTitle()), null, (String)String.valueOf(this._fileEntry.getFileEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._request);
        }
        catch (Exception e) {
            throw new SystemException("Unable to create permissions URL", (Throwable)e);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("Liferay.Util.openWindow({title: '");
        sb.append(UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"permissions"));
        sb.append("', uri: '");
        sb.append(permissionsURL);
        sb.append("'});");
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.PERMISSIONS, LanguageUtil.get((HttpServletRequest)this._request, (String)"permissions"), sb.toString());
    }

    public void addViewOriginalFileMenuItem(List<MenuItem> menuItems) {
        if (this._fileShortcut == null) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/view_file_entry");
        portletURL.setParameter("redirect", this._getCurrentURL());
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileShortcut.getToFileEntryId()));
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.VIEW_ORIGINAL_FILE, "view-original-file", portletURL.toString());
    }

    public JavaScriptMenuItem getJavacriptCheckinMenuItem() throws PortalException {
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "checkin");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        JavaScriptMenuItem javascriptMenuItem = new JavaScriptMenuItem();
        javascriptMenuItem.setKey(DLUIItemKeys.CHECKIN);
        javascriptMenuItem.setLabel("checkin");
        javascriptMenuItem.setOnClick(this.getNamespace() + "showVersionDetailsDialog('" + portletURL + "');");
        String javaScript = "/com/liferay/document/library/web/display/context/dependencies/checkin_js.ftl";
        Class<?> clazz = this.getClass();
        URLTemplateResource urlTemplateResource = new URLTemplateResource(javaScript, clazz.getResource(javaScript));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        template.put((Object)"dialogTitle", (Object)UnicodeLanguageUtil.get((HttpServletRequest)this._request, (String)"describe-your-changes"));
        template.put((Object)"namespace", (Object)this.getNamespace());
        template.put((Object)"randomNamespace", this._request.getAttribute("randomNamespace"));
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        javascriptMenuItem.setJavaScript(unsyncStringWriter.toString());
        return javascriptMenuItem;
    }

    public boolean isOpenInMsOfficeActionAvailable() throws PortalException {
        return this._fileEntryDisplayContextHelper.hasViewPermission() && this._fileVersionDisplayContextHelper.isMsOffice() && this._isWebDAVEnabled() && this._isIEOnWin32();
    }

    protected String getNamespace() {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        return liferayPortletResponse.getNamespace();
    }

    protected String getSubmitFormJavaScript(String cmd, String redirect) {
        StringBundler sb = new StringBundler(18);
        sb.append("document.");
        sb.append(this.getNamespace());
        sb.append("fm.");
        sb.append(this.getNamespace());
        sb.append("cmd");
        sb.append(".value = '");
        sb.append(cmd);
        sb.append("';");
        if (redirect != null) {
            sb.append("document.");
            sb.append(this.getNamespace());
            sb.append("fm.");
            sb.append(this.getNamespace());
            sb.append("redirect.value = '");
            sb.append(redirect);
            sb.append("';");
        }
        sb.append("submitForm(document.");
        sb.append(this.getNamespace());
        sb.append("fm);");
        return sb.toString();
    }

    protected boolean isDeleteActionAvailable() throws PortalException {
        return this._fileEntryDisplayContextHelper.isFileEntryDeletable() && !this._isFileEntryTrashable();
    }

    protected boolean isMoveToTheRecycleBinActionAvailable() throws PortalException {
        return !this.isDeleteActionAvailable() && this._fileEntryDisplayContextHelper.isFileEntryDeletable();
    }

    private UIItemsBuilder(HttpServletRequest request, FileVersion fileVersion, FileShortcut fileShortcut) {
        try {
            this._request = request;
            this._fileVersion = fileVersion;
            this._fileShortcut = fileShortcut;
            FileEntry fileEntry = null;
            if (fileVersion != null) {
                fileEntry = fileVersion.getFileEntry();
            }
            this._fileEntry = fileEntry;
            this._folderId = BeanParamUtil.getLong((Object)this._fileEntry, (HttpServletRequest)request, (String)"folderId");
            this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._fileEntryDisplayContextHelper = new FileEntryDisplayContextHelper(this._themeDisplay.getPermissionChecker(), this._fileEntry);
            this._fileVersionDisplayContextHelper = new FileVersionDisplayContextHelper(fileVersion);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to build UIItemsBuilder for " + fileVersion, (Throwable)pe);
        }
    }

    private <T extends JavaScriptUIItem> T _addJavaScriptUIItem(T javascriptUIItem, List<? super T> javascriptUIItems, String key, String label, String onClick) {
        javascriptUIItem.setKey(key);
        javascriptUIItem.setLabel(label);
        javascriptUIItem.setOnClick(onClick);
        javascriptUIItems.add(javascriptUIItem);
        return javascriptUIItem;
    }

    private <T extends URLUIItem> T _addURLUIItem(T urlUIItem, List<? super T> urlUIItems, String key, String label, String url) {
        urlUIItem.setKey(key);
        urlUIItem.setLabel(label);
        urlUIItem.setURL(url);
        urlUIItems.add(urlUIItem);
        return urlUIItem;
    }

    private PortletURL _getActionURL(String mvcActionCommandName, String cmd) {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createActionURL();
        portletURL.setParameter("javax.portlet.action", mvcActionCommandName);
        portletURL.setParameter("cmd", cmd);
        portletURL.setParameter("redirect", this._getCurrentURL());
        return portletURL;
    }

    private String _getCurrentURL() {
        if (this._currentURL != null) {
            return this._currentURL;
        }
        LiferayPortletRequest liferayPortletRequest = this._getLiferayPortletRequest();
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = PortletURLUtil.getCurrent((LiferayPortletRequest)liferayPortletRequest, (LiferayPortletResponse)liferayPortletResponse);
        this._currentURL = portletURL.toString();
        return this._currentURL;
    }

    private LiferayPortletRequest _getLiferayPortletRequest() {
        PortletRequest portletRequest = (PortletRequest)this._request.getAttribute("javax.portlet.request");
        return PortalUtil.getLiferayPortletRequest((PortletRequest)portletRequest);
    }

    private LiferayPortletResponse _getLiferayPortletResponse() {
        PortletResponse portletResponse = (PortletResponse)this._request.getAttribute("javax.portlet.response");
        return PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse);
    }

    private PortletURL _getRenderURL(String mvcRenderCommandName) {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
        portletURL.setParameter("redirect", this._getCurrentURL());
        if (this._fileShortcut != null) {
            portletURL.setParameter("fileShortcutId", String.valueOf(this._fileShortcut.getFileShortcutId()));
        } else {
            portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        }
        return portletURL;
    }

    private boolean _isFileEntryTrashable() throws PortalException {
        return this._fileEntryDisplayContextHelper.isDLFileEntry() && this._isTrashEnabled();
    }

    private boolean _isIEOnWin32() {
        if (this._ieOnWin32 == null) {
            this._ieOnWin32 = BrowserSnifferUtil.isIeOnWin32((HttpServletRequest)this._request);
        }
        return this._ieOnWin32;
    }

    private boolean _isTrashEnabled() throws PortalException {
        if (this._trashEnabled == null) {
            this._trashEnabled = DLTrashUtil.isTrashEnabled(this._themeDisplay.getScopeGroupId(), this._fileEntry.getRepositoryId());
        }
        return this._trashEnabled;
    }

    private boolean _isWebDAVEnabled() {
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        return portletDisplay.isWebDAVEnabled();
    }
}

