/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context;

import com.liferay.document.library.display.context.DLMimeTypeDisplayContext;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.document.library.kernel.util.AudioProcessorUtil;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.document.library.kernel.util.PDFProcessorUtil;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;
import com.liferay.document.library.web.internal.display.context.logic.DLPortletInstanceSettingsHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileEntryDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileVersionDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.logic.UIItemsBuilder;
import com.liferay.document.library.web.internal.display.context.util.DLRequestHelper;
import com.liferay.document.library.web.internal.display.context.util.JSPRenderer;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultDLViewFileVersionDisplayContext
implements DLViewFileVersionDisplayContext {
    private static final UUID _UUID = UUID.fromString("85F6C50E-3893-4E32-9D63-208528A503FA");
    private List<DDMStructure> _ddmStructures;
    private final DLMimeTypeDisplayContext _dlMimeTypeDisplayContext;
    private final DLPortletInstanceSettingsHelper _dlPortletInstanceSettingsHelper;
    private final FileEntryDisplayContextHelper _fileEntryDisplayContextHelper;
    private final FileVersion _fileVersion;
    private final FileVersionDisplayContextHelper _fileVersionDisplayContextHelper;
    private final ResourceBundleLoader _resourceBundleLoader;
    private final StorageEngine _storageEngine;
    private final UIItemsBuilder _uiItemsBuilder;

    public DefaultDLViewFileVersionDisplayContext(HttpServletRequest request, HttpServletResponse response, FileShortcut fileShortcut, DLMimeTypeDisplayContext dlMimeTypeDisplayContext, ResourceBundleLoader resourceBundleLoader, StorageEngine storageEngine) throws PortalException {
        this(request, fileShortcut.getFileVersion(), fileShortcut, dlMimeTypeDisplayContext, resourceBundleLoader, storageEngine);
    }

    public DefaultDLViewFileVersionDisplayContext(HttpServletRequest request, HttpServletResponse response, FileVersion fileVersion, DLMimeTypeDisplayContext dlMimeTypeDisplayContext, ResourceBundleLoader resourceBundleLoader, StorageEngine storageEngine) {
        this(request, fileVersion, null, dlMimeTypeDisplayContext, resourceBundleLoader, storageEngine);
    }

    public String getCssClassFileMimeType() {
        if (this._dlMimeTypeDisplayContext == null) {
            return "file-icon-color-0";
        }
        return this._dlMimeTypeDisplayContext.getCssClassFileMimeType(this._fileVersion.getMimeType());
    }

    public DDMFormValues getDDMFormValues(DDMStructure ddmStructure) throws PortalException {
        DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)this._fileVersion.getFileVersionId());
        return this._storageEngine.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
    }

    public DDMFormValues getDDMFormValues(long classPK) throws StorageException {
        return this._storageEngine.getDDMFormValues(classPK);
    }

    public List<DDMStructure> getDDMStructures() throws PortalException {
        if (this._ddmStructures != null) {
            return this._ddmStructures;
        }
        if (this._fileVersionDisplayContextHelper.isDLFileVersion()) {
            DLFileVersion dlFileVersion = (DLFileVersion)this._fileVersion.getModel();
            this._ddmStructures = dlFileVersion.getDDMStructures();
        } else {
            this._ddmStructures = Collections.emptyList();
        }
        return this._ddmStructures;
    }

    public int getDDMStructuresCount() throws PortalException {
        List<DDMStructure> ddmStructures = this.getDDMStructures();
        return ddmStructures.size();
    }

    public String getDiscussionClassName() {
        return DLFileEntryConstants.getClassName();
    }

    public long getDiscussionClassPK() {
        return this._fileVersion.getFileEntryId();
    }

    public String getDiscussionLabel(Locale locale) {
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(LanguageUtil.getLanguageId((Locale)locale));
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"comments");
    }

    public Menu getMenu() throws PortalException {
        Menu menu = new Menu();
        menu.setDirection("left-side");
        menu.setMarkupView("lexicon");
        menu.setMenuItems(this._getMenuItems());
        menu.setScroll(false);
        menu.setShowWhenSingleIcon(true);
        return menu;
    }

    public List<ToolbarItem> getToolbarItems() throws PortalException {
        ArrayList<ToolbarItem> toolbarItems = new ArrayList<ToolbarItem>();
        this._uiItemsBuilder.addDownloadToolbarItem(toolbarItems);
        this._uiItemsBuilder.addOpenInMsOfficeToolbarItem(toolbarItems);
        this._uiItemsBuilder.addEditToolbarItem(toolbarItems);
        this._uiItemsBuilder.addMoveToolbarItem(toolbarItems);
        this._uiItemsBuilder.addCheckoutToolbarItem(toolbarItems);
        this._uiItemsBuilder.addCancelCheckoutToolbarItem(toolbarItems);
        this._uiItemsBuilder.addCheckinToolbarItem(toolbarItems);
        this._uiItemsBuilder.addPermissionsToolbarItem(toolbarItems);
        this._uiItemsBuilder.addMoveToTheRecycleBinToolbarItem(toolbarItems);
        this._uiItemsBuilder.addDeleteToolbarItem(toolbarItems);
        return toolbarItems;
    }

    public UUID getUuid() {
        return _UUID;
    }

    public boolean hasPreview() {
        return AudioProcessorUtil.hasAudio((FileVersion)this._fileVersion) || ImageProcessorUtil.hasImages((FileVersion)this._fileVersion) || PDFProcessorUtil.hasImages((FileVersion)this._fileVersion) || VideoProcessorUtil.hasVideo((FileVersion)this._fileVersion);
    }

    public boolean isDownloadLinkVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isDownloadActionAvailable();
    }

    public boolean isVersionInfoVisible() {
        return true;
    }

    public void renderPreview(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JSPRenderer jspRenderer = new JSPRenderer("/document_library/view_file_entry_preview.jsp");
        jspRenderer.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", this._fileVersion);
        jspRenderer.render(request, response);
    }

    private DefaultDLViewFileVersionDisplayContext(HttpServletRequest request, FileVersion fileVersion, FileShortcut fileShortcut, DLMimeTypeDisplayContext dlMimeTypeDisplayContext, ResourceBundleLoader resourceBundleLoader, StorageEngine storageEngine) {
        try {
            this._fileVersion = fileVersion;
            this._dlMimeTypeDisplayContext = dlMimeTypeDisplayContext;
            this._resourceBundleLoader = resourceBundleLoader;
            this._storageEngine = storageEngine;
            DLRequestHelper dlRequestHelper = new DLRequestHelper(request);
            this._dlPortletInstanceSettingsHelper = new DLPortletInstanceSettingsHelper(dlRequestHelper);
            this._fileEntryDisplayContextHelper = new FileEntryDisplayContextHelper(dlRequestHelper.getPermissionChecker(), this._getFileEntry(fileVersion));
            this._fileVersionDisplayContextHelper = new FileVersionDisplayContextHelper(fileVersion);
            this._uiItemsBuilder = fileShortcut == null ? new UIItemsBuilder(request, fileVersion) : new UIItemsBuilder(request, fileShortcut);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to build DefaultDLViewFileVersionDisplayContext for " + fileVersion, (Throwable)pe);
        }
    }

    private FileEntry _getFileEntry(FileVersion fileVersion) throws PortalException {
        if (fileVersion != null) {
            return fileVersion.getFileEntry();
        }
        return null;
    }

    private List<MenuItem> _getMenuItems() throws PortalException {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        if (this._dlPortletInstanceSettingsHelper.isShowActions()) {
            this._uiItemsBuilder.addDownloadMenuItem(menuItems);
            this._uiItemsBuilder.addOpenInMsOfficeMenuItem(menuItems);
            this._uiItemsBuilder.addViewOriginalFileMenuItem(menuItems);
            this._uiItemsBuilder.addEditMenuItem(menuItems);
            this._uiItemsBuilder.addMoveMenuItem(menuItems);
            this._uiItemsBuilder.addCheckoutMenuItem(menuItems);
            this._uiItemsBuilder.addCheckinMenuItem(menuItems);
            this._uiItemsBuilder.addCancelCheckoutMenuItem(menuItems);
            this._uiItemsBuilder.addPermissionsMenuItem(menuItems);
            this._uiItemsBuilder.addDeleteMenuItem(menuItems);
        }
        return menuItems;
    }
}

