/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context;

import com.liferay.document.library.display.context.DLEditFileEntryDisplayContext;
import com.liferay.document.library.display.context.DLFilePicker;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.web.internal.display.context.logic.FileEntryDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileVersionDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.util.DLRequestHelper;
import com.liferay.document.library.web.internal.settings.DLPortletInstanceSettings;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultDLEditFileEntryDisplayContext
implements DLEditFileEntryDisplayContext {
    private static final UUID _UUID = UUID.fromString("63326141-02F6-42B5-AE38-ABC73FA72BB5");
    private final DLFileEntryType _dlFileEntryType;
    private final DLRequestHelper _dlRequestHelper;
    private final FileEntry _fileEntry;
    private final FileEntryDisplayContextHelper _fileEntryDisplayContextHelper;
    private final FileVersion _fileVersion;
    private final FileVersionDisplayContextHelper _fileVersionDisplayContextHelper;
    private final boolean _showSelectFolder;
    private final StorageEngine _storageEngine;

    public DefaultDLEditFileEntryDisplayContext(HttpServletRequest request, HttpServletResponse response, DLFileEntryType dlFileEntryType, StorageEngine storageEngine) {
        this(request, dlFileEntryType, null, storageEngine);
    }

    public DefaultDLEditFileEntryDisplayContext(HttpServletRequest request, HttpServletResponse response, FileEntry fileEntry, StorageEngine storageEngine) {
        this(request, (DLFileEntryType)null, fileEntry, storageEngine);
    }

    public DDMFormValues getDDMFormValues(long classPK) throws StorageException {
        return this._storageEngine.getDDMFormValues(classPK);
    }

    public DLFilePicker getDLFilePicker(String onFilePickCallback) {
        return null;
    }

    public long getMaximumUploadRequestSize() {
        return PrefsPropsUtil.getLong((String)"com.liferay.portal.upload.UploadServletRequestImpl.max.size");
    }

    public long getMaximumUploadSize() {
        long fileMaxSize = PrefsPropsUtil.getLong((String)"dl.file.max.size");
        if (fileMaxSize == 0L) {
            fileMaxSize = this.getMaximumUploadRequestSize();
        }
        return fileMaxSize;
    }

    public String getPublishButtonLabel() {
        if (this._hasFolderWorkflowDefinitionLink()) {
            return "submit-for-publication";
        }
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        if (dlPortletInstanceSettings.isEnableFileEntryDrafts() || this._fileEntryDisplayContextHelper.isCheckedOut()) {
            return "save";
        }
        return "publish";
    }

    public String getSaveButtonLabel() {
        String saveButtonLabel = "save";
        if (this._fileVersion == null || this._fileVersionDisplayContextHelper.isApproved() || this._fileVersionDisplayContextHelper.isDraft()) {
            saveButtonLabel = "save-as-draft";
        }
        return saveButtonLabel;
    }

    public UUID getUuid() {
        return _UUID;
    }

    public boolean isCancelCheckoutDocumentButtonDisabled() {
        return false;
    }

    public boolean isCancelCheckoutDocumentButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCancelCheckoutDocumentActionAvailable();
    }

    public boolean isCheckinButtonDisabled() {
        return false;
    }

    public boolean isCheckinButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCheckinActionAvailable();
    }

    public boolean isCheckoutDocumentButtonDisabled() {
        return false;
    }

    public boolean isCheckoutDocumentButtonVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isCheckoutDocumentActionAvailable();
    }

    public boolean isDDMStructureVisible(DDMStructure ddmStructure) {
        return true;
    }

    public boolean isFolderSelectionVisible() {
        return this._showSelectFolder;
    }

    public boolean isPublishButtonDisabled() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        return this._fileEntryDisplayContextHelper.isCheckedOutByOther() || this._fileVersionDisplayContextHelper.isPending() && dlPortletInstanceSettings.isEnableFileEntryDrafts();
    }

    public boolean isPublishButtonVisible() {
        return true;
    }

    public boolean isSaveButtonDisabled() {
        return this._fileEntryDisplayContextHelper.isCheckedOutByOther();
    }

    public boolean isSaveButtonVisible() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        return dlPortletInstanceSettings.isEnableFileEntryDrafts();
    }

    public boolean isVersionInfoVisible() {
        return true;
    }

    private DefaultDLEditFileEntryDisplayContext(HttpServletRequest request, DLFileEntryType dlFileEntryType, FileEntry fileEntry, StorageEngine storageEngine) {
        try {
            this._dlRequestHelper = new DLRequestHelper(request);
            this._fileEntry = fileEntry;
            this._storageEngine = storageEngine;
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._fileEntryDisplayContextHelper = new FileEntryDisplayContextHelper(themeDisplay.getPermissionChecker(), this._fileEntry);
            this._dlFileEntryType = dlFileEntryType == null && fileEntry != null ? this._fileEntryDisplayContextHelper.getDLFileEntryType() : dlFileEntryType;
            this._fileVersion = fileEntry != null ? fileEntry.getFileVersion() : null;
            this._fileVersionDisplayContextHelper = new FileVersionDisplayContextHelper(this._fileVersion);
            this._showSelectFolder = ParamUtil.getBoolean((HttpServletRequest)request, (String)"showSelectFolder");
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to build DefaultDLEditFileEntryDisplayContext for " + fileEntry, (Throwable)pe);
        }
    }

    private boolean _hasFolderWorkflowDefinitionLink() {
        try {
            if (this._dlFileEntryType == null) {
                return false;
            }
            long folderId = BeanParamUtil.getLong((Object)this._fileEntry, (HttpServletRequest)this._dlRequestHelper.getRequest(), (String)"folderId");
            return DLUtil.hasWorkflowDefinitionLink((long)this._dlRequestHelper.getCompanyId(), (long)this._dlRequestHelper.getScopeGroupId(), (long)folderId, (long)this._dlFileEntryType.getFileEntryTypeId());
        }
        catch (Exception e) {
            throw new SystemException("Unable to check if folder has workflow definition link", (Throwable)e);
        }
    }
}

