/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DLFolderAssetRenderer
extends BaseJSPAssetRenderer<Folder>
implements TrashRenderer {
    public static final String TYPE = "folder";
    private static final Log _log = LogFactoryUtil.getLog(DLFolderAssetRenderer.class);
    private final Folder _folder;

    public DLFolderAssetRenderer(Folder folder) {
        this._folder = folder;
    }

    public Folder getAssetObject() {
        return this._folder;
    }

    public String getClassName() {
        return DLFolder.class.getName();
    }

    public long getClassPK() {
        return this._folder.getPrimaryKey();
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._folder.getModifiedDate();
    }

    public long getGroupId() {
        return this._folder.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/document_library/asset/folder_" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._folder.getDescription();
    }

    public String getTitle(Locale locale) {
        return TrashUtil.getOriginalTitle((String)this._folder.getName());
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._folder.getGroupId());
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_document_library_web_portlet_DLAdminPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_folder");
        portletURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        return portletURL;
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        portletURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/document_library/find_folder", "folderId", this._folder.getFolderId());
    }

    public long getUserId() {
        return this._folder.getUserId();
    }

    public String getUserName() {
        return this._folder.getUserName();
    }

    public String getUuid() {
        return this._folder.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFolderPermission.contains((PermissionChecker)permissionChecker, (Folder)this._folder, (String)"UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFolderPermission.contains((PermissionChecker)permissionChecker, (Folder)this._folder, (String)"VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("DOCUMENT_LIBRARY_FOLDER", (Object)this._folder);
        return super.include(request, response, template);
    }

    public boolean isDisplayable() {
        return !this._folder.isMountPoint();
    }
}

