/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.uad.anonymizer;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.uad.anonymizer.BaseDLFileEntryUADAnonymizer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UADAnonymizer.class})
public class DLFileEntryUADAnonymizer
extends BaseDLFileEntryUADAnonymizer {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    @Override
    public void autoAnonymize(DLFileEntry dlFileEntry, long userId, User anonymousUser) throws PortalException {
        List dlFileVersions = dlFileEntry.getFileVersions(-1);
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            this._anonymizeDLFileVersion(dlFileVersion, userId, anonymousUser.getUserId(), anonymousUser.getFullName());
        }
        super.autoAnonymize(dlFileEntry, userId, anonymousUser);
    }

    @Override
    public void delete(DLFileEntry dlFileEntry) throws PortalException {
        this._dlAppLocalService.deleteFileEntry(dlFileEntry.getFileEntryId());
    }

    private void _anonymizeDLFileVersion(DLFileVersion dlFileVersion, long userId, long anonymousUserId, String anonymousUserFullName) {
        if (userId == dlFileVersion.getUserId()) {
            dlFileVersion.setUserId(anonymousUserId);
            dlFileVersion.setUserName(anonymousUserFullName);
        }
        if (userId == dlFileVersion.getStatusByUserId()) {
            dlFileVersion.setStatusByUserId(anonymousUserId);
            dlFileVersion.setStatusByUserName(anonymousUserFullName);
        }
        this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
    }
}

