/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.uad.anonymizer;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.uad.constants.DLUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseDLFileEntryUADAnonymizer
extends DynamicQueryUADAnonymizer<DLFileEntry> {
    @Reference
    protected DLFileEntryLocalService dlFileEntryLocalService;

    public void autoAnonymize(DLFileEntry dlFileEntry, long userId, User anonymousUser) throws PortalException {
        if (dlFileEntry.getUserId() == userId) {
            dlFileEntry.setUserId(anonymousUser.getUserId());
            dlFileEntry.setUserName(anonymousUser.getFullName());
        }
        this.dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
    }

    public void delete(DLFileEntry dlFileEntry) throws PortalException {
        this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
    }

    public Class<DLFileEntry> getTypeClass() {
        return DLFileEntry.class;
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.dlFileEntryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return DLUADConstants.USER_ID_FIELD_NAMES_DL_FILE_ENTRY;
    }
}

