/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.document.library.uad.display;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.uad.constants.DLUADConstants;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;

import com.liferay.user.associated.data.display.BaseModelUADDisplay;

import org.osgi.service.component.annotations.Reference;

import java.io.Serializable;

import java.util.List;

/**
 * Provides the base implementation for the DLFileEntry UAD display.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom methods should be put in
 * {@link DLFileEntryUADDisplay}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseDLFileEntryUADDisplay extends BaseModelUADDisplay<DLFileEntry> {
	@Override
	public DLFileEntry get(Serializable primaryKey) throws PortalException {
		return dlFileEntryLocalService.getDLFileEntry(Long.valueOf(
				primaryKey.toString()));
	}

	@Override
	public String[] getDisplayFieldNames() {
		return new String[] { "fileName", "extension", "title", "description" };
	}

	@Override
	public Class<DLFileEntry> getTypeClass() {
		return DLFileEntry.class;
	}

	@Override
	protected long doCount(DynamicQuery dynamicQuery) {
		return dlFileEntryLocalService.dynamicQueryCount(dynamicQuery);
	}

	@Override
	protected DynamicQuery doGetDynamicQuery() {
		return dlFileEntryLocalService.dynamicQuery();
	}

	@Override
	protected List<DLFileEntry> doGetRange(DynamicQuery dynamicQuery,
		int start, int end) {
		return dlFileEntryLocalService.dynamicQuery(dynamicQuery, start, end);
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return DLUADConstants.USER_ID_FIELD_NAMES_DL_FILE_ENTRY;
	}

	@Reference
	protected DLFileEntryLocalService dlFileEntryLocalService;
}