/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.document.library.uad.anonymizer;

import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.uad.constants.DLUADConstants;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;

import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the document library file shortcut UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link DLFileShortcutUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseDLFileShortcutUADAnonymizer
	extends DynamicQueryUADAnonymizer<DLFileShortcut> {
	@Override
	public void autoAnonymize(DLFileShortcut dlFileShortcut, long userId,
		User anonymousUser) throws PortalException {
		if (dlFileShortcut.getUserId() == userId) {
			dlFileShortcut.setUserId(anonymousUser.getUserId());
			dlFileShortcut.setUserName(anonymousUser.getFullName());
		}

		if (dlFileShortcut.getStatusByUserId() == userId) {
			dlFileShortcut.setStatusByUserId(anonymousUser.getUserId());
			dlFileShortcut.setStatusByUserName(anonymousUser.getFullName());
		}

		dlFileShortcutLocalService.updateDLFileShortcut(dlFileShortcut);
	}

	@Override
	public void delete(DLFileShortcut dlFileShortcut) throws PortalException {
		dlFileShortcutLocalService.deleteFileShortcut(dlFileShortcut);
	}

	@Override
	public Class<DLFileShortcut> getTypeClass() {
		return DLFileShortcut.class;
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return dlFileShortcutLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return DLUADConstants.USER_ID_FIELD_NAMES_DL_FILE_SHORTCUT;
	}

	@Reference
	protected DLFileShortcutLocalService dlFileShortcutLocalService;
}