/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.document.library.uad.anonymizer;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.uad.constants.DLUADConstants;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;

import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the document library file entry type UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link DLFileEntryTypeUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseDLFileEntryTypeUADAnonymizer
	extends DynamicQueryUADAnonymizer<DLFileEntryType> {
	@Override
	public void autoAnonymize(DLFileEntryType dlFileEntryType, long userId,
		User anonymousUser) throws PortalException {
		if (dlFileEntryType.getUserId() == userId) {
			dlFileEntryType.setUserId(anonymousUser.getUserId());
			dlFileEntryType.setUserName(anonymousUser.getFullName());
		}

		dlFileEntryTypeLocalService.updateDLFileEntryType(dlFileEntryType);
	}

	@Override
	public void delete(DLFileEntryType dlFileEntryType)
		throws PortalException {
		dlFileEntryTypeLocalService.deleteFileEntryType(dlFileEntryType);
	}

	@Override
	public Class<DLFileEntryType> getTypeClass() {
		return DLFileEntryType.class;
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return dlFileEntryTypeLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return DLUADConstants.USER_ID_FIELD_NAMES_DL_FILE_ENTRY_TYPE;
	}

	@Reference
	protected DLFileEntryTypeLocalService dlFileEntryTypeLocalService;
}