/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.test.util.search;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.test.util.search.FileEntryBlueprint;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portlet.documentlibrary.util.test.DLAppTestUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FileEntrySearchFixture {
    protected final DLAppLocalService dlAppLocalService;
    private final List<FileEntry> _fileEntries = new ArrayList<FileEntry>();

    public FileEntrySearchFixture(DLAppLocalService dlAppLocalService1) {
        this.dlAppLocalService = dlAppLocalService1;
    }

    public FileEntry addFileEntry(FileEntryBlueprint fileEntryBlueprint) {
        ServiceContext serviceContext = this.getServiceContext(fileEntryBlueprint);
        serviceContext.setAssetTagNames(fileEntryBlueprint.getAssetTagNames());
        FileEntry fileEntry = fileEntryBlueprint.getInputStream() != null ? this.addFileEntry(fileEntryBlueprint.getInputStream(), fileEntryBlueprint, serviceContext) : this.addFileEntryWithWorkflow(fileEntryBlueprint.getUserId(), fileEntryBlueprint.getGroupId(), fileEntryBlueprint.getTitle(), serviceContext);
        this._fileEntries.add(fileEntry);
        return fileEntry;
    }

    public List<FileEntry> getFileEntries() {
        return this._fileEntries;
    }

    public void setUp() {
    }

    public void tearDown() throws Exception {
        for (FileEntry fileEntry : this._fileEntries) {
            this.dlAppLocalService.deleteFileEntry(fileEntry.getFileEntryId());
        }
        this._fileEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileEntry addFileEntry(InputStream inputStream, FileEntryBlueprint fileEntryBlueprint, ServiceContext serviceContext) {
        File file = this.createTempFile(inputStream);
        try {
            FileEntry fileEntry = this.addFileEntry(fileEntryBlueprint.getFileName(), fileEntryBlueprint.getTitle(), file, serviceContext);
            return fileEntry;
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    protected FileEntry addFileEntry(String fileName, String title, File file, ServiceContext serviceContext) {
        try {
            return this.dlAppLocalService.addFileEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, fileName, MimeTypesUtil.getContentType((String)fileName), title, "", "", file, serviceContext);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    protected FileEntry addFileEntryWithWorkflow(long userId, long groupId, String title, ServiceContext serviceContext) {
        try {
            return DLAppTestUtil.addFileEntryWithWorkflow((long)userId, (long)groupId, (long)0L, (String)"", (String)title, (boolean)true, (ServiceContext)serviceContext);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected File createTempFile(InputStream inputStream) {
        try {
            return FileUtil.createTempFile((InputStream)inputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected ServiceContext getServiceContext(FileEntryBlueprint fileEntryBlueprint) {
        try {
            if (fileEntryBlueprint.getUserId() != null) {
                return ServiceContextTestUtil.getServiceContext((long)fileEntryBlueprint.getGroupId(), (long)fileEntryBlueprint.getUserId());
            }
            return ServiceContextTestUtil.getServiceContext((long)fileEntryBlueprint.getGroupId());
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }
}

