/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.result.contributor;

import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelPreFilterContributor.class})
public class DLFileEntryModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected DDMStructureManager ddmStructureManager;
    protected RelatedEntryIndexer relatedEntryIndexer = new BaseRelatedEntryIndexer();
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    protected ModelPreFilterContributor workflowStatusModelPreFilterContributor;
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryModelPreFilterContributor.class);

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this.addAttachmentFilter(booleanFilter, searchContext);
        this.addClassTypeIdsFilter(booleanFilter, modelSearchSettings, searchContext);
        this.addDDMFieldFilter(booleanFilter, searchContext);
        this.addWorkflowStatusFilter(booleanFilter, modelSearchSettings, searchContext);
        this.addHiddenFilter(booleanFilter, searchContext);
        this.addMimeTypesFilter(booleanFilter, searchContext);
    }

    protected void addAttachmentFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        if (!searchContext.isIncludeAttachments()) {
            return;
        }
        try {
            this.relatedEntryIndexer.addRelatedClassNames(booleanFilter, searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void addClassTypeIdsFilter(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        long[] classTypeIds = searchContext.getClassTypeIds();
        if (ArrayUtil.isEmpty((long[])classTypeIds)) {
            return;
        }
        TermsFilter termsFilter = new TermsFilter("classTypeId");
        termsFilter.addValues(ArrayUtil.toStringArray((long[])classTypeIds));
        booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
    }

    protected void addDDMFieldFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        block4: {
            try {
                Serializable ddmStructureFieldValue;
                String ddmStructureFieldName;
                block5: {
                    ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
                    ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
                    if (!Validator.isNotNull((String)ddmStructureFieldName) || !Validator.isNotNull((Object)ddmStructureFieldValue)) break block4;
                    String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
                    DDMStructure ddmStructure = this.ddmStructureManager.getStructure(GetterUtil.getLong((String)ddmStructureFieldNameParts[2]));
                    String fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)searchContext.getLocale())), (String)"");
                    try {
                        ddmStructureFieldValue = this.ddmStructureManager.getIndexedFieldValue(ddmStructureFieldValue, ddmStructure.getFieldType(fieldName));
                    }
                    catch (Exception e) {
                        if (!_log.isDebugEnabled()) break block5;
                        _log.debug((Object)e, (Throwable)e);
                    }
                }
                BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
                booleanQuery.addRequiredTerm(ddmStructureFieldName, "\"" + ddmStructureFieldValue + "\"");
                booleanFilter.add((Filter)new QueryFilter((Query)booleanQuery), BooleanClauseOccur.MUST);
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
    }

    protected void addHiddenFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        if ((ArrayUtil.isEmpty((long[])searchContext.getFolderIds()) || ArrayUtil.contains((long[])searchContext.getFolderIds(), (long)0L)) && !searchContext.isIncludeAttachments()) {
            booleanFilter.addRequiredTerm("hidden", false);
        }
    }

    protected void addMimeTypesFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        Object[] mimeTypes = (String[])searchContext.getAttribute("mimeTypes");
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            BooleanFilter mimeTypesBooleanFilter = new BooleanFilter();
            for (Object mimeType : mimeTypes) {
                mimeTypesBooleanFilter.addTerm("mimeType", StringUtil.replace((String)mimeType, (char)'/', (char)'_'));
            }
            booleanFilter.add((Filter)mimeTypesBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    protected void addWorkflowStatusFilter(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this.workflowStatusModelPreFilterContributor.contribute(booleanFilter, modelSearchSettings, searchContext);
    }
}

