/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.index.contributor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManager;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.trash.TrashHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelDocumentContributor.class})
public class DLFileEntryModelDocumentContributor
implements ModelDocumentContributor<DLFileEntry> {
    @Reference
    protected DDMStructureManager ddmStructureManager;
    @Reference
    protected DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService;
    @Reference
    protected Portal portal;
    @Reference
    protected RelatedEntryIndexerRegistry relatedEntryIndexerRegistry;
    @Reference
    protected StorageEngineManager storageEngineManager;
    @Reference
    protected TrashHelper trashHelper;
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryModelDocumentContributor.class);

    public void contribute(Document document, DLFileEntry dlFileEntry) {
        DLFileVersion dlFileVersion;
        InputStream is;
        boolean indexContent;
        block26: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Indexing document " + dlFileEntry));
            }
            indexContent = true;
            Object[] ignoreExtensions = PrefsPropsUtil.getStringArray((String)"dl.file.indexing.ignore.extensions", (String)",");
            if (ArrayUtil.contains((Object[])ignoreExtensions, (Object)("." + dlFileEntry.getExtension()))) {
                indexContent = false;
            }
            is = null;
            if (indexContent) {
                try {
                    dlFileVersion = dlFileEntry.getFileVersion();
                    is = dlFileVersion.getContentStream(false);
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block26;
                    _log.debug((Object)"Unable to retrieve document stream", (Throwable)e);
                }
            }
        }
        try {
            List relatedEntryIndexers;
            dlFileVersion = dlFileEntry.getFileVersion();
            if (indexContent) {
                if (is != null) {
                    try {
                        Locale defaultLocale = this.portal.getSiteDefaultLocale(dlFileEntry.getGroupId());
                        String localizedField = Field.getLocalizedName((String)defaultLocale.toString(), (String)"content");
                        document.addFile(localizedField, is, dlFileEntry.getTitle(), PropsValues.DL_FILE_INDEXING_MAX_SIZE);
                    }
                    catch (IOException ioe) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)"Unable to index content", (Throwable)ioe);
                        }
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Document " + dlFileEntry + " does not have any content"));
                }
            }
            document.addKeyword("classTypeId", dlFileEntry.getFileEntryTypeId());
            document.addText("description", dlFileEntry.getDescription());
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addText("properties", dlFileEntry.getLuceneProperties());
            document.addKeyword("status", dlFileVersion.getStatus());
            String title = dlFileEntry.getTitle();
            if (dlFileEntry.isInTrash()) {
                title = this.trashHelper.getOriginalTitle(title);
            }
            document.addText("title", title);
            document.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
            document.addKeyword("dataRepositoryId", dlFileEntry.getDataRepositoryId());
            document.addText("ddmContent", this.extractDDMContent(dlFileVersion, LocaleUtil.getSiteDefault()));
            document.addTextSortable("extension", dlFileEntry.getExtension());
            document.addKeyword("fileEntryTypeId", dlFileEntry.getFileEntryTypeId());
            document.addTextSortable("mimeType", StringUtil.replace((String)dlFileEntry.getMimeType(), (char)'/', (char)'_'));
            document.addKeyword("path", dlFileEntry.getTitle());
            document.addKeyword("readCount", dlFileEntry.getReadCount());
            document.addNumber("size", dlFileEntry.getSize());
            this.addFileEntryTypeAttributes(document, dlFileVersion);
            if (dlFileEntry.isInHiddenFolder() && ListUtil.isNotEmpty((List)(relatedEntryIndexers = this.relatedEntryIndexerRegistry.getRelatedEntryIndexers(dlFileEntry.getClassName())))) {
                for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                    relatedEntryIndexer.addRelatedEntryFields(document, (Object)new LiferayFileEntry(dlFileEntry));
                    DocumentHelper documentHelper = new DocumentHelper(document);
                    documentHelper.setAttachmentOwnerKey(this.portal.getClassNameId(dlFileEntry.getClassName()), dlFileEntry.getClassPK());
                    document.addKeyword("relatedEntry", true);
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + dlFileEntry + " indexed successfully"));
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void addFileEntryTypeAttributes(Document document, DLFileVersion dlFileVersion) throws PortalException {
        List dlFileEntryMetadatas = this.dlFileEntryMetadataLocalService.getFileVersionFileEntryMetadatas(dlFileVersion.getFileVersionId());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            try {
                DDMFormValues ddmFormValues = this.storageEngineManager.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
                if (ddmFormValues == null) continue;
                this.ddmStructureManager.addAttributes(dlFileEntryMetadata.getDDMStructureId(), document, ddmFormValues);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to retrieve metadata values", (Throwable)e);
            }
        }
    }

    protected String extractDDMContent(DLFileVersion dlFileVersion, Locale locale) throws Exception {
        List dlFileEntryMetadatas = this.dlFileEntryMetadataLocalService.getFileVersionFileEntryMetadatas(dlFileVersion.getFileVersionId());
        StringBundler sb = new StringBundler(dlFileEntryMetadatas.size());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            try {
                DDMFormValues ddmFormValues = this.storageEngineManager.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
                if (ddmFormValues == null) continue;
                sb.append(this.ddmStructureManager.extractAttributes(dlFileEntryMetadata.getDDMStructureId(), ddmFormValues, locale));
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to retrieve metadata values", (Throwable)e);
            }
        }
        return sb.toString();
    }
}

