/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.document.library.security.io.InputStreamSanitizer;
import com.liferay.document.library.service.DLFileVersionPreviewLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileEntryWrapper;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.FileVersionWrapper;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.repository.liferayrepository.LiferayProcessorLocalRepositoryWrapper;
import com.liferay.portal.repository.liferayrepository.LiferayProcessorRepositoryWrapper;
import com.liferay.portal.repository.util.RepositoryWrapperAware;
import java.io.InputStream;

public class LiferayProcessorCapability
implements ProcessorCapability,
RepositoryEventAware,
RepositoryWrapperAware {
    private final DLFileVersionPreviewLocalService _dlFileVersionPreviewLocalService;
    private final InputStreamSanitizer _inputStreamSanitizer;
    private final ProcessorCapability.ResourceGenerationStrategy _resourceGenerationStrategy;

    public LiferayProcessorCapability(ProcessorCapability.ResourceGenerationStrategy resourceGenerationStrategy, DLFileVersionPreviewLocalService dlFileVersionPreviewLocalService, InputStreamSanitizer inputStreamSanitizer) {
        this._resourceGenerationStrategy = resourceGenerationStrategy;
        this._dlFileVersionPreviewLocalService = dlFileVersionPreviewLocalService;
        this._inputStreamSanitizer = inputStreamSanitizer;
    }

    public void cleanUp(FileEntry fileEntry) {
        DLProcessorRegistryUtil.cleanUp((FileEntry)fileEntry);
    }

    public void cleanUp(FileVersion fileVersion) {
        DLProcessorRegistryUtil.cleanUp((FileVersion)fileVersion);
    }

    public void copy(FileEntry fileEntry, FileVersion fileVersion) {
        if (this._resourceGenerationStrategy == ProcessorCapability.ResourceGenerationStrategy.REUSE) {
            this.registerDLProcessorCallback(fileEntry, fileVersion);
        } else {
            this.generateNew(fileEntry);
        }
    }

    public void generateNew(FileEntry fileEntry) {
        this.registerDLProcessorCallback(fileEntry, null);
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, FileEntry.class, fileEntry -> {
            this._dlFileVersionPreviewLocalService.deleteDLFileEntryFileVersionPreviews(fileEntry.getFileEntryId());
            this.cleanUp((FileEntry)fileEntry);
        });
    }

    public LocalRepository wrapLocalRepository(LocalRepository localRepository) {
        return new LiferayProcessorLocalRepositoryWrapper(localRepository, (ProcessorCapability)this);
    }

    public Repository wrapRepository(Repository repository) {
        return new LiferayProcessorRepositoryWrapper(repository, (ProcessorCapability)this);
    }

    protected void registerDLProcessorCallback(FileEntry fileEntry, FileVersion fileVersion) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            DLProcessorRegistryUtil.trigger((FileEntry)this._wrap(fileEntry), (FileVersion)this._wrap(fileVersion), (boolean)true);
            return null;
        });
    }

    private FileEntry _wrap(FileEntry fileEntry) {
        if (fileEntry == null) {
            return null;
        }
        if ("image/png".equals(fileEntry.getMimeType())) {
            return new SafeFileEntry(fileEntry);
        }
        return fileEntry;
    }

    private FileVersion _wrap(FileVersion fileVersion) {
        if (fileVersion == null) {
            return null;
        }
        if ("image/png".equals(fileVersion.getMimeType())) {
            return new SafeFileVersion(fileVersion);
        }
        return fileVersion;
    }

    private class SafeFileVersion
    extends FileVersionWrapper {
        public SafeFileVersion(FileVersion fileVersion) {
            super(fileVersion);
        }

        public InputStream getContentStream(boolean incrementCounter) throws PortalException {
            return LiferayProcessorCapability.this._inputStreamSanitizer.sanitize(super.getContentStream(incrementCounter));
        }

        public FileEntry getFileEntry() throws PortalException {
            return new SafeFileEntry(super.getFileEntry());
        }
    }

    private class SafeFileEntry
    extends FileEntryWrapper {
        public SafeFileEntry(FileEntry fileEntry) {
            super(fileEntry);
        }

        public InputStream getContentStream() throws PortalException {
            return LiferayProcessorCapability.this._inputStreamSanitizer.sanitize(super.getContentStream());
        }

        public InputStream getContentStream(String version) throws PortalException {
            return LiferayProcessorCapability.this._inputStreamSanitizer.sanitize(super.getContentStream(version));
        }

        public FileVersion getFileVersion() throws PortalException {
            return new SafeFileVersion(super.getFileVersion());
        }

        public FileVersion getFileVersion(String version) throws PortalException {
            return new SafeFileVersion(super.getFileVersion(version));
        }

        public FileVersion getLatestFileVersion() throws PortalException {
            return new SafeFileVersion(super.getLatestFileVersion());
        }

        public FileVersion getLatestFileVersion(boolean trusted) throws PortalException {
            return new SafeFileVersion(super.getLatestFileVersion(trusted));
        }
    }
}

