/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.instance.lifecycle;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.util.RawMetadataProcessor;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, immediate=true, service={PortalInstanceLifecycleListener.class})
public class AddDefaultDocumentLibraryStructuresPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private DDM _ddm;
    private DDMFormDeserializer _ddmFormDeserializer;
    @Reference
    private DDMFormSerializerTracker _ddmFormSerializerTracker;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DefaultDDMStructureHelper _defaultDDMStructureHelper;
    private volatile DLConfiguration _dlConfiguration;
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!this._dlConfiguration.addDefaultStructures()) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAddGroupPermissions(true);
        Group group = this._groupLocalService.getCompanyGroup(company.getCompanyId());
        serviceContext.setScopeGroupId(group.getGroupId());
        long defaultUserId = this._userLocalService.getDefaultUserId(company.getCompanyId());
        serviceContext.setUserId(defaultUserId);
        this._defaultDDMStructureHelper.addDDMStructures(defaultUserId, group.getGroupId(), this._portal.getClassNameId(DLFileEntryMetadata.class), this.getClassLoader(), "com/liferay/document/library/events/dependencies/document-library-structures.xml", serviceContext);
        this._dlFileEntryTypeLocalService.getBasicDocumentDLFileEntryType();
        this.addDLRawMetadataStructures(defaultUserId, group.getGroupId(), serviceContext);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    protected void addDLRawMetadataStructures(long userId, long groupId, ServiceContext serviceContext) throws Exception {
        Locale locale = this._portal.getSiteDefaultLocale(groupId);
        String xsd = this.buildDLRawMetadataXML(RawMetadataProcessorUtil.getFields(), locale);
        Document document = UnsecureSAXReaderUtil.read((Reader)new StringReader(xsd));
        Element rootElement = document.getRootElement();
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            String name = structureElement.elementText("name");
            String description = structureElement.elementText("description");
            Element structureElementRootElement = structureElement.element("root");
            String structureElementRootXML = structureElementRootElement.asXML();
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, this._portal.getClassNameId(RawMetadataProcessor.class), name);
            DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)structureElementRootXML);
            DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._ddmFormDeserializer.deserialize(builder.build());
            DDMForm ddmForm = ddmFormDeserializerDeserializeResponse.getDDMForm();
            if (ddmStructure != null) {
                String definition = this._serializeJSONDDMForm(ddmForm);
                if (definition.equals(ddmStructure.getDefinition())) continue;
                ddmStructure.setDDMForm(ddmForm);
                this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
                continue;
            }
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            nameMap.put(locale, name);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(locale, description);
            DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
            this._ddmStructureLocalService.addStructure(userId, groupId, 0L, this._portal.getClassNameId(RawMetadataProcessor.class), name, nameMap, descriptionMap, ddmForm, ddmFormLayout, StorageType.JSON.toString(), 0, serviceContext);
        }
    }

    protected String buildDLRawMetadataElementXML(Field field, Locale locale) {
        StringBundler sb = new StringBundler(14);
        sb.append("<dynamic-element dataType=\"string\" indexType=\"text\" ");
        sb.append("name=\"");
        Class<?> fieldClass = field.getDeclaringClass();
        sb.append(fieldClass.getSimpleName());
        sb.append("_");
        sb.append(field.getName());
        sb.append("\" localizable=\"false\" required=\"false\" ");
        sb.append("showLabel=\"true\" type=\"text\"><meta-data locale=\"");
        sb.append((Object)locale);
        sb.append("\"><entry name=\"label\"><![CDATA[metadata.");
        sb.append(fieldClass.getSimpleName());
        sb.append(".");
        sb.append(field.getName());
        sb.append("]]></entry><entry name=\"predefinedValue\">");
        sb.append("<![CDATA[]]></entry></meta-data></dynamic-element>");
        return sb.toString();
    }

    protected String buildDLRawMetadataStructureXML(String name, Field[] fields, Locale locale) {
        StringBundler sb = new StringBundler(12 + fields.length);
        sb.append("<structure><name><![CDATA[");
        sb.append(name);
        sb.append("]]></name><description><![CDATA[");
        sb.append(name);
        sb.append("]]></description><root available-locales=\"");
        sb.append((Object)locale);
        sb.append("\" default-locale=\"");
        sb.append((Object)locale);
        sb.append("\">");
        for (Field field : fields) {
            sb.append(this.buildDLRawMetadataElementXML(field, locale));
        }
        sb.append("</root></structure>");
        return sb.toString();
    }

    protected String buildDLRawMetadataXML(Map<String, Field[]> fields, Locale locale) {
        StringBundler sb = new StringBundler(2 + fields.size());
        sb.append("<?xml version=\"1.0\"?><root>");
        for (Map.Entry<String, Field[]> entry : fields.entrySet()) {
            sb.append(this.buildDLRawMetadataStructureXML(entry.getKey(), entry.getValue(), locale));
        }
        sb.append("</root>");
        return sb.toString();
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(target="(component.name=com.liferay.dynamic.data.mapping.io.internal.DDMFormXSDDeserializer)", unbind="-")
    protected void setDDMFormDeserializer(DDMFormDeserializer ddmFormDeserializer) {
        this._ddmFormDeserializer = ddmFormDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDefaultDDMStructureHelper(DefaultDDMStructureHelper defaultDDMStructureHelper) {
        this._defaultDDMStructureHelper = defaultDDMStructureHelper;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryTypeLocalService(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private String _serializeJSONDDMForm(DDMForm ddmForm) {
        DDMFormSerializer ddmFormSerializer = this._ddmFormSerializerTracker.getDDMFormSerializer("json");
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = ddmFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }
}

