/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.exportimport.staged.model.repository;

import com.liferay.document.library.exportimport.data.handler.DLExportableRepositoryPublisher;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.Folder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.document.library.kernel.model.DLFolder"}, service={StagedModelRepository.class})
public class FolderStagedModelRepository
implements StagedModelRepository<Folder> {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    private ServiceTrackerList<DLExportableRepositoryPublisher, DLExportableRepositoryPublisher> _dlExportableRepositoryPublishers;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;

    public Folder addStagedModel(PortletDataContext portletDataContext, Folder folder) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void deleteStagedModel(Folder folder) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public Folder fetchMissingReference(String uuid, long groupId) {
        throw new UnsupportedOperationException();
    }

    public Folder fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        throw new UnsupportedOperationException();
    }

    public List<Folder> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        throw new UnsupportedOperationException();
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(portletDataContext);
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._dlFolderLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property property = PropertyFactoryUtil.forName((String)"repositoryId");
            dynamicQuery.add(property.in(exportableRepositoryIds));
        });
        exportActionableDynamicQuery.setPerformActionMethod(dlFolder -> {
            if (dlFolder.isInTrash()) {
                return;
            }
            Folder folder = this._dlAppLocalService.getFolder(dlFolder.getFolderId());
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DLFolderConstants.getClassName()));
        return exportActionableDynamicQuery;
    }

    public Folder getStagedModel(long folderId) throws PortalException {
        return this._dlAppLocalService.getFolder(folderId);
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, Folder folder) throws PortletDataException {
        throw new UnsupportedOperationException();
    }

    public Folder saveStagedModel(Folder folder) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public Folder updateStagedModel(PortletDataContext portletDataContext, Folder folder) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._dlExportableRepositoryPublishers = ServiceTrackerListFactory.open((BundleContext)bundleContext, DLExportableRepositoryPublisher.class);
    }

    @Deactivate
    protected void deactivate() {
        if (this._dlExportableRepositoryPublishers != null) {
            this._dlExportableRepositoryPublishers.close();
        }
    }

    private Collection<Long> _getExportableRepositoryIds(PortletDataContext portletDataContext) {
        HashSet<Long> exportableRepositoryIds = new HashSet<Long>();
        exportableRepositoryIds.add(portletDataContext.getScopeGroupId());
        for (DLExportableRepositoryPublisher dlExportableRepositoryPublisher : this._dlExportableRepositoryPublishers) {
            dlExportableRepositoryPublisher.publish(portletDataContext.getScopeGroupId(), exportableRepositoryIds::add);
        }
        return exportableRepositoryIds;
    }
}

