/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.display.context;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.display.context.DLMimeTypeDisplayContext;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={DLMimeTypeDisplayContext.class})
public class DefaultDLMimeTypeDisplayContext
implements DLMimeTypeDisplayContext {
    private volatile DLConfiguration _dlConfiguration;

    public String getCssClassFileMimeType(String mimeType) {
        if (this._containsMimeType(this._dlConfiguration.codeFileMimeTypes(), mimeType)) {
            return "file-icon-color-0";
        }
        if (this._containsMimeType(this._dlConfiguration.compressedFileMimeTypes(), mimeType)) {
            return "file-icon-color-0";
        }
        if (this._containsMimeType(this._dlConfiguration.multimediaFileMimeTypes(), mimeType)) {
            return "file-icon-color-5";
        }
        if (this._containsMimeType(this._dlConfiguration.presentationFileMimeTypes(), mimeType)) {
            return "file-icon-color-4";
        }
        if (this._containsMimeType(this._dlConfiguration.spreadSheetFileMimeTypes(), mimeType)) {
            return "file-icon-color-2";
        }
        if (this._containsMimeType(this._dlConfiguration.textFileMimeTypes(), mimeType)) {
            return "file-icon-color-6";
        }
        if (this._containsMimeType(this._dlConfiguration.vectorialFileMimeTypes(), mimeType)) {
            return "file-icon-color-3";
        }
        return "file-icon-color-0";
    }

    public String getIconFileMimeType(String mimeType) {
        if (this._containsMimeType(this._dlConfiguration.codeFileMimeTypes(), mimeType)) {
            return "document-code";
        }
        if (this._containsMimeType(this._dlConfiguration.compressedFileMimeTypes(), mimeType)) {
            return "document-compressed";
        }
        if (this._containsMimeType(this._dlConfiguration.multimediaFileMimeTypes(), mimeType)) {
            if (mimeType.startsWith("image")) {
                return "document-image";
            }
            return "document-multimedia";
        }
        if (this._containsMimeType(this._dlConfiguration.presentationFileMimeTypes(), mimeType)) {
            return "document-presentation";
        }
        if (this._containsMimeType(this._dlConfiguration.spreadSheetFileMimeTypes(), mimeType)) {
            return "document-table";
        }
        if (this._containsMimeType(this._dlConfiguration.textFileMimeTypes(), mimeType)) {
            return "document-text";
        }
        if (this._containsMimeType(this._dlConfiguration.vectorialFileMimeTypes(), mimeType)) {
            return "document-vector";
        }
        return "document-default";
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    private boolean _containsMimeType(String[] mimeTypes, String mimeType) {
        for (String curMimeType : mimeTypes) {
            int pos = curMimeType.indexOf("/");
            if (!(pos != -1 ? mimeType.equals(curMimeType) : mimeType.startsWith(curMimeType))) continue;
            return true;
        }
        return false;
    }
}

