/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection.action;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.document.library.bulk.selection.EditCategoriesBulkSelectionAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BulkSelectionAction.class, EditCategoriesBulkSelectionAction.class, EditCategoriesBulkSelectionActionImpl.class})
public class EditCategoriesBulkSelectionActionImpl
implements EditCategoriesBulkSelectionAction {
    private static final Log _log = LogFactoryUtil.getLog(EditCategoriesBulkSelectionActionImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;

    public void execute(User user, BulkSelection<AssetEntry> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        long[] toAddCategoryIds = this._getLongArray(inputMap, "toAddCategoryIds");
        Set toAddCategoryIdsSet = SetUtil.fromArray((long[])toAddCategoryIds);
        Set toRemoveCategoryIdsSet = SetUtil.fromArray((long[])this._getLongArray(inputMap, "toRemoveCategoryIds"));
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        bulkSelection.forEach(assetEntry -> {
            block4: {
                try {
                    if (!BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)permissionChecker, (long)assetEntry.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)"UPDATE").booleanValue()) {
                        return;
                    }
                    long[] newCategoryIds = toAddCategoryIds;
                    if (MapUtil.getBoolean((Map)inputMap, (String)"append")) {
                        Set currentCategoryIdsSet = SetUtil.fromArray((long[])assetEntry.getCategoryIds());
                        currentCategoryIdsSet.removeAll(toRemoveCategoryIdsSet);
                        currentCategoryIdsSet.addAll(toAddCategoryIdsSet);
                        newCategoryIds = ArrayUtil.toLongArray((Collection)currentCategoryIdsSet);
                    }
                    this._assetEntryLocalService.updateEntry(assetEntry.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK(), newCategoryIds, assetEntry.getTagNames());
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)pe, (Throwable)pe);
                }
            }
        });
    }

    private long[] _getLongArray(Map<String, Serializable> map, String key) {
        return ArrayUtil.toArray((Long[])((Long[])map.getOrDefault(key, (Serializable)new Long[0])));
    }
}

