/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.bulk.selection.BaseSingleEntryBulkSelection;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.FileShortcutBulkSelectionFactory;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.Map;

public class SingleFileShortcutBulkSelection
extends BaseSingleEntryBulkSelection<FileShortcut> {
    private final DLAppService _dlAppService;
    private final long _fileShortcutId;

    public SingleFileShortcutBulkSelection(long fileShortcutId, Map<String, String[]> parameterMap, ResourceBundleLoader resourceBundleLoader, Language language, DLAppService dlAppService) {
        super(fileShortcutId, parameterMap, resourceBundleLoader, language);
        this._fileShortcutId = fileShortcutId;
        this._dlAppService = dlAppService;
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return FileShortcutBulkSelectionFactory.class;
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        throw new UnsupportedOperationException("File shortcut is not an asset");
    }

    protected FileShortcut getEntry() throws PortalException {
        return this._dlAppService.getFileShortcut(this._fileShortcutId);
    }

    protected String getEntryName() throws PortalException {
        FileShortcut fileShortcut = this.getEntry();
        return fileShortcut.getToTitle();
    }
}

