/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.bulk.selection.BaseMultipleEntryBulkSelection;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.FolderBulkSelectionFactory;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.Map;

public class MultipleFolderBulkSelection
extends BaseMultipleEntryBulkSelection<Folder> {
    private static final Log _log = LogFactoryUtil.getLog(MultipleFolderBulkSelection.class);
    private final DLAppService _dlAppService;

    public MultipleFolderBulkSelection(long[] folderIds, Map<String, String[]> parameterMap, ResourceBundleLoader resourceBundleLoader, Language language, DLAppService dlAppService) {
        super(folderIds, parameterMap, resourceBundleLoader, language);
        this._dlAppService = dlAppService;
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return FolderBulkSelectionFactory.class;
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        throw new UnsupportedOperationException("Folder is not an asset");
    }

    protected Folder fetchEntry(long folderId) {
        try {
            return this._dlAppService.getFolder(folderId);
        }
        catch (NoSuchFolderException nsfe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsfe, (Throwable)nsfe);
            }
            return null;
        }
        catch (PortalException pe) {
            return (Folder)ReflectionUtil.throwException((Throwable)pe);
        }
    }
}

