/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BaseMultipleEntryBulkSelection;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.FileEntryAssetEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FileEntryBulkSelectionFactory;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.Map;

public class MultipleFileEntryBulkSelection
extends BaseMultipleEntryBulkSelection<FileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(MultipleFileEntryBulkSelection.class);
    private final AssetEntryLocalService _assetEntryLocalService;
    private final DLAppService _dlAppService;

    public MultipleFileEntryBulkSelection(long[] fileEntryIds, Map<String, String[]> parameterMap, ResourceBundleLoader resourceBundleLoader, Language language, DLAppService dlAppService, AssetEntryLocalService assetEntryLocalService) {
        super(fileEntryIds, parameterMap, resourceBundleLoader, language);
        this._dlAppService = dlAppService;
        this._assetEntryLocalService = assetEntryLocalService;
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return FileEntryBulkSelectionFactory.class;
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        return new FileEntryAssetEntryBulkSelection((BulkSelection<FileEntry>)this, this._assetEntryLocalService);
    }

    protected FileEntry fetchEntry(long fileEntryId) {
        try {
            return this._dlAppService.getFileEntry(fileEntryId);
        }
        catch (NoSuchFileEntryException nsfee) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsfee, (Throwable)nsfee);
            }
            return null;
        }
        catch (PortalException pe) {
            return (FileEntry)ReflectionUtil.throwException((Throwable)pe);
        }
    }
}

