/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.BaseFolderEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FileShortcutBulkSelectionFactory;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.BaseRepositoryModelOperation;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.Map;

public class FolderFileShortcutBulkSelection
extends BaseFolderEntryBulkSelection<FileShortcut> {
    private final DLAppService _dlAppService;
    private final long _folderId;
    private final long _repositoryId;

    public FolderFileShortcutBulkSelection(long repositoryId, long folderId, Map<String, String[]> parameterMap, ResourceBundleLoader resourceBundleLoader, Language language, RepositoryProvider repositoryProvider, DLAppService dlAppService) {
        super(repositoryId, folderId, parameterMap, resourceBundleLoader, language, repositoryProvider);
        this._repositoryId = repositoryId;
        this._folderId = folderId;
        this._dlAppService = dlAppService;
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return FileShortcutBulkSelectionFactory.class;
    }

    public long getSize() throws PortalException {
        int fileEntriesAndFileShortcutsCount = this._dlAppService.getFileEntriesAndFileShortcutsCount(this._repositoryId, this._folderId, 0);
        int fileEntriesCount = this._dlAppService.getFileEntriesCount(this._repositoryId, this._folderId);
        return fileEntriesAndFileShortcutsCount - fileEntriesCount;
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        throw new UnsupportedOperationException("File shortcut is not an asset");
    }

    @Override
    protected <E extends PortalException> RepositoryModelOperation getRepositoryModelOperation(final UnsafeConsumer<? super FileShortcut, E> action) {
        return new BaseRepositoryModelOperation(){

            public void execute(FileShortcut fileShortcut) throws PortalException {
                action.accept((Object)fileShortcut);
            }
        };
    }
}

