/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.EmptyBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FolderFileShortcutBulkSelection;
import com.liferay.document.library.internal.bulk.selection.MultipleFileShortcutBulkSelection;
import com.liferay.document.library.internal.bulk.selection.SingleFileShortcutBulkSelection;
import com.liferay.document.library.internal.bulk.selection.util.BulkSelectionFactoryUtil;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.document.library.kernel.model.DLFileShortcut"}, service={BulkSelectionFactory.class, FileShortcutBulkSelectionFactory.class})
public class FileShortcutBulkSelectionFactory
implements BulkSelectionFactory<FileShortcut> {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private Language _language;
    @Reference
    private RepositoryProvider _repositoryProvider;
    @Reference(target="(bundle.symbolic.name=com.liferay.document.library.service)")
    private ResourceBundleLoader _resourceBundleLoader;

    public BulkSelection<FileShortcut> create(Map<String, String[]> parameterMap) {
        if (BulkSelectionFactoryUtil.isSelectAll(parameterMap)) {
            long repositoryId = BulkSelectionFactoryUtil.getRepositoryId(parameterMap);
            long folderId = BulkSelectionFactoryUtil.getFolderId(parameterMap);
            return new FolderFileShortcutBulkSelection(repositoryId, folderId, parameterMap, this._resourceBundleLoader, this._language, this._repositoryProvider, this._dlAppService);
        }
        if (!parameterMap.containsKey("rowIdsDLFileShortcut")) {
            return new EmptyBulkSelection<FileShortcut>();
        }
        String[] values = parameterMap.get("rowIdsDLFileShortcut");
        return this._getFileShortcutSelection(values, parameterMap);
    }

    private BulkSelection<FileShortcut> _getFileShortcutSelection(String[] values, Map<String, String[]> parameterMap) {
        long[] fileShortcutIds;
        if (values.length == 1) {
            values = StringUtil.split((String)values[0]);
        }
        if ((fileShortcutIds = GetterUtil.getLongValues((String[])values)).length == 1) {
            return new SingleFileShortcutBulkSelection(fileShortcutIds[0], parameterMap, this._resourceBundleLoader, this._language, this._dlAppService);
        }
        return new MultipleFileShortcutBulkSelection(fileShortcutIds, parameterMap, this._resourceBundleLoader, this._language, this._dlAppService);
    }
}

