/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.EmptyBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FolderFileEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.MultipleFileEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.SingleFileEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.util.BulkSelectionFactoryUtil;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={BulkSelectionFactory.class, FileEntryBulkSelectionFactory.class})
public class FileEntryBulkSelectionFactory
implements BulkSelectionFactory<FileEntry> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private Language _language;
    @Reference
    private RepositoryProvider _repositoryProvider;
    @Reference(target="(bundle.symbolic.name=com.liferay.document.library.service)")
    private ResourceBundleLoader _resourceBundleLoader;

    public BulkSelection<FileEntry> create(Map<String, String[]> parameterMap) {
        if (BulkSelectionFactoryUtil.isSelectAll(parameterMap)) {
            long repositoryId = BulkSelectionFactoryUtil.getRepositoryId(parameterMap);
            long folderId = BulkSelectionFactoryUtil.getFolderId(parameterMap);
            return new FolderFileEntryBulkSelection(repositoryId, folderId, parameterMap, this._resourceBundleLoader, this._language, this._repositoryProvider, this._dlAppService, this._assetEntryLocalService);
        }
        if (!parameterMap.containsKey("rowIdsFileEntry")) {
            return new EmptyBulkSelection<FileEntry>();
        }
        String[] values = parameterMap.get("rowIdsFileEntry");
        return this._getFileEntrySelection(values, parameterMap);
    }

    private BulkSelection<FileEntry> _getFileEntrySelection(String[] values, Map<String, String[]> parameterMap) {
        long[] fileEntryIds;
        if (values.length == 1) {
            values = StringUtil.split((String)values[0]);
        }
        if ((fileEntryIds = GetterUtil.getLongValues((String[])values)).length == 1) {
            return new SingleFileEntryBulkSelection(fileEntryIds[0], parameterMap, this._resourceBundleLoader, this._language, this._dlAppService, this._assetEntryLocalService);
        }
        return new MultipleFileEntryBulkSelection(fileEntryIds, parameterMap, this._resourceBundleLoader, this._language, this._dlAppService, this._assetEntryLocalService);
    }
}

