/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.upgrade.v1_0_0;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true)
public class StoreProvider {
    private BundleContext _bundleContext;
    private ServiceRegistration<Store> _serviceRegistration;
    private ServiceTracker<Store, Store> _serviceTracker;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, Store.class, (ServiceTrackerCustomizer)new StoreServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class StoreServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Store, Store> {
        private StoreServiceTrackerCustomizer() {
        }

        public Store addingService(ServiceReference<Store> serviceReference) {
            Store store = (Store)StoreProvider.this._bundleContext.getService(serviceReference);
            String storeType = (String)serviceReference.getProperty("store.type");
            if (storeType == null || !storeType.equals(PropsValues.DL_STORE_IMPL)) {
                return store;
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("dl.store.upgrade", "true");
            StoreProvider.this._serviceRegistration = StoreProvider.this._bundleContext.registerService(Store.class, (Object)store, properties);
            return store;
        }

        public void modifiedService(ServiceReference<Store> serviceReference, Store store) {
            this.removedService(serviceReference, store);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<Store> serviceReference, Store store) {
            StoreProvider.this._bundleContext.ungetService(serviceReference);
            try {
                StoreProvider.this._serviceRegistration.unregister();
            }
            catch (IllegalStateException ise) {
                return;
            }
        }
    }
}

