/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search;

import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.IndexerWriterMode;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelIndexerWriterContributor.class})
public class DLFileEntryModelIndexerWriterContributor
implements ModelIndexerWriterContributor<DLFileEntry> {
    @Reference
    protected DLFileEntryLocalService dlFileEntryLocalService;
    @Reference
    protected DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory;
    @Reference
    protected Props props;
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryModelIndexerWriterContributor.class);
    private int _dlFileIndexingInterval;

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setInterval(this._dlFileIndexingInterval);
        batchIndexingActionable.setPerformActionMethod(dlFileEntry -> batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)dlFileEntry)}));
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this.dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this.dlFileEntryLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(DLFileEntry dlFileEntry) {
        return dlFileEntry.getCompanyId();
    }

    public IndexerWriterMode getIndexerWriterMode(DLFileEntry dlFileEntry) {
        DLFileVersion dlFileVersion = null;
        try {
            dlFileVersion = dlFileEntry.getFileVersion();
        }
        catch (NoSuchFileVersionException nsfve) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get file version for file entry " + dlFileEntry.getFileEntryId()), (Throwable)nsfve);
            }
            return IndexerWriterMode.SKIP;
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
        if (!dlFileVersion.isApproved() && !dlFileEntry.isInTrash()) {
            return IndexerWriterMode.SKIP;
        }
        return IndexerWriterMode.UPDATE;
    }

    @Activate
    protected void activate() {
        this._dlFileIndexingInterval = GetterUtil.getInteger((String)this.props.get("dl.file.indexing.interval"), (int)500);
    }
}

