/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class RepositoryStagedModelDataHandler
extends BaseStagedModelDataHandler<Repository> {
    public static final String[] CLASS_NAMES = new String[]{Repository.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(RepositoryStagedModelDataHandler.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private RepositoryEntryLocalService _repositoryEntryLocalService;
    @Reference
    private RepositoryLocalService _repositoryLocalService;

    public void deleteStagedModel(Repository repository) throws PortalException {
        this._repositoryLocalService.deleteRepository(repository.getRepositoryId());
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Repository repository = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (repository != null) {
            this.deleteStagedModel(repository);
        }
    }

    public Repository fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._repositoryLocalService.fetchRepositoryByUuidAndGroupId(uuid, groupId);
    }

    public List<Repository> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._repositoryLocalService.getRepositoriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Repository repository) {
        return repository.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Repository repository) throws Exception {
        Element repositoryElement = portletDataContext.getExportDataElement((ClassedModel)repository);
        Folder folder = this._dlAppLocalService.getFolder(repository.getDlFolderId());
        if (folder.getModel() instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            repositoryElement.addAttribute("hidden", String.valueOf(dlFolder.isHidden()));
        }
        repositoryElement.addAttribute("repositoryClassName", repository.getClassName());
        portletDataContext.addClassedModel(repositoryElement, ExportImportPathUtil.getModelPath((StagedModel)repository), (ClassedModel)repository);
        List repositoryEntries = this._repositoryEntryLocalService.getRepositoryEntries(repository.getRepositoryId());
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)repository, (StagedModel)repositoryEntry, (String)"child");
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Repository repository) throws Exception {
        Repository importedRepository;
        block9: {
            long userId = portletDataContext.getUserId(repository.getUserUuid());
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)repository);
            importedRepository = null;
            Element repositoryElement = portletDataContext.getImportDataStagedModelElement((StagedModel)repository);
            try {
                boolean hidden = GetterUtil.getBoolean((String)repositoryElement.attributeValue("hidden"));
                Repository existingRepository = this.fetchStagedModelByUuidAndGroupId(repository.getUuid(), portletDataContext.getScopeGroupId());
                if (existingRepository == null) {
                    existingRepository = this._repositoryLocalService.fetchRepository(portletDataContext.getScopeGroupId(), repository.getName());
                }
                if (portletDataContext.isDataStrategyMirror()) {
                    if (existingRepository == null) {
                        serviceContext.setUuid(repository.getUuid());
                        long repositoryClassNameId = this._getRepositoryClassNameId(repositoryElement, repository.getClassNameId());
                        importedRepository = this._repositoryLocalService.addRepository(userId, portletDataContext.getScopeGroupId(), repositoryClassNameId, 0L, repository.getName(), repository.getDescription(), repository.getPortletId(), repository.getTypeSettingsProperties(), hidden, serviceContext);
                    } else {
                        this._repositoryLocalService.updateRepository(existingRepository.getRepositoryId(), repository.getName(), repository.getDescription());
                        importedRepository = existingRepository;
                    }
                } else if (existingRepository == null) {
                    long repositoryClassNameId = this._getRepositoryClassNameId(repositoryElement, repository.getClassNameId());
                    importedRepository = this._repositoryLocalService.addRepository(userId, portletDataContext.getScopeGroupId(), repositoryClassNameId, 0L, repository.getName(), repository.getDescription(), repository.getPortletId(), repository.getTypeSettingsProperties(), hidden, serviceContext);
                } else {
                    importedRepository = existingRepository;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to connect to repository {name=", repository.getName(), ", typeSettings=", String.valueOf(repository.getTypeSettingsProperties()), "}"}), (Throwable)e);
            }
        }
        portletDataContext.importClassedModel((ClassedModel)repository, importedRepository);
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)repository, RepositoryEntry.class);
    }

    protected boolean isSkipImportReferenceStagedModels() {
        return true;
    }

    private long _getRepositoryClassNameId(Element repositoryElement, long defaultValue) {
        String repositoryClassName = repositoryElement.attributeValue("repositoryClassName");
        if (Validator.isNull((String)repositoryClassName)) {
            return defaultValue;
        }
        return this._classNameLocalService.getClassNameId(repositoryClassName);
    }
}

