/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.verify;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.document.library.kernel.util.comparator.DLFileVersionVersionComparator;
import com.liferay.portal.instances.service.PortalInstancesLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.springframework.context.ApplicationContext;

@Component(immediate=true, property={"verify.process.name=com.liferay.document.library.service"}, service={VerifyProcess.class})
public class DLServiceVerifyProcess
extends VerifyProcess {
    private static final String _MS_OFFICE_2010_TEXT_XML_UTF8 = "text/xml; charset=\"utf-8\"";
    private static final Log _log = LogFactoryUtil.getLog(DLServiceVerifyProcess.class);
    private CounterLocalService _counterLocalService;
    private DLAppHelperLocalService _dlAppHelperLocalService;
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    private DLFileVersionLocalService _dlFileVersionLocalService;
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private DLValidator _dlValidator;
    @Reference
    private PortalInstancesLocalService _portalInstancesLocalService;

    protected void addDLFileVersion(DLFileEntry dlFileEntry) {
        long fileVersionId = this._counterLocalService.increment();
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.createDLFileVersion(fileVersionId);
        dlFileVersion.setGroupId(dlFileEntry.getGroupId());
        dlFileVersion.setCompanyId(dlFileEntry.getCompanyId());
        long userId = dlFileEntry.getUserId();
        dlFileVersion.setUserId(userId);
        String userName = dlFileEntry.getUserName();
        dlFileVersion.setUserName(userName);
        dlFileVersion.setCreateDate(dlFileEntry.getModifiedDate());
        dlFileVersion.setModifiedDate(dlFileEntry.getModifiedDate());
        dlFileVersion.setRepositoryId(dlFileEntry.getRepositoryId());
        dlFileVersion.setFolderId(dlFileEntry.getFolderId());
        dlFileVersion.setFileEntryId(dlFileEntry.getFileEntryId());
        dlFileVersion.setExtension(dlFileEntry.getExtension());
        dlFileVersion.setMimeType(dlFileEntry.getMimeType());
        dlFileVersion.setTitle(dlFileEntry.getTitle());
        dlFileVersion.setDescription(dlFileEntry.getDescription());
        dlFileVersion.setExtraSettings(dlFileEntry.getExtraSettings());
        dlFileVersion.setFileEntryTypeId(dlFileEntry.getFileEntryTypeId());
        dlFileVersion.setVersion(dlFileEntry.getVersion());
        dlFileVersion.setSize(dlFileEntry.getSize());
        dlFileVersion.setStatus(0);
        dlFileVersion.setStatusByUserId(userId);
        dlFileVersion.setStatusByUserName(userName);
        dlFileVersion.setStatusDate(new Date());
        this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
    }

    protected void checkDLFileEntryMetadata() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List mismatchedCompanyIdDLFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getMismatchedCompanyIdFileEntryMetadatas();
            if (_log.isDebugEnabled()) {
                int size = mismatchedCompanyIdDLFileEntryMetadatas.size();
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Deleting ", String.valueOf(size), " file entry metadatas with mismatched company IDs"}));
            }
            for (DLFileEntryMetadata dlFileEntryMetadata : mismatchedCompanyIdDLFileEntryMetadatas) {
                this.deleteUnusedDLFileEntryMetadata(dlFileEntryMetadata);
            }
            List noStructuresDLFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getNoStructuresFileEntryMetadatas();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Deleting " + noStructuresDLFileEntryMetadatas.size() + " file entry metadatas with no structures"));
            }
            for (DLFileEntryMetadata dlFileEntryMetadata : noStructuresDLFileEntryMetadatas) {
                this.deleteUnusedDLFileEntryMetadata(dlFileEntryMetadata);
            }
        }
    }

    protected void checkDLFileEntryType() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.fetchDLFileEntryType(0L);
            if (dlFileEntryType != null) {
                return;
            }
            dlFileEntryType = this._dlFileEntryTypeLocalService.createDLFileEntryType(0L);
            dlFileEntryType.setCompanyId(0L);
            dlFileEntryType.setFileEntryTypeKey(StringUtil.toUpperCase((String)"basic-document"));
            dlFileEntryType.setName("basic-document", LocaleUtil.getDefault());
            this._dlFileEntryTypeLocalService.updateDLFileEntryType(dlFileEntryType);
        }
    }

    protected void checkFileVersionMimeTypes(final String[] originalMimeTypes) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileVersionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Criterion criterion = RestrictionsFactoryUtil.eq((String)"mimeType", (Object)originalMimeTypes[0]);
                for (int i = 1; i < originalMimeTypes.length; ++i) {
                    criterion = RestrictionsFactoryUtil.or((Criterion)criterion, (Criterion)RestrictionsFactoryUtil.eq((String)"mimeType", (Object)originalMimeTypes[i]));
                }
                dynamicQuery.add(criterion);
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFileVersion>(){

            public void performAction(DLFileVersion dlFileVersion) {
                block9: {
                    InputStream inputStream = null;
                    try {
                        inputStream = DLServiceVerifyProcess.this._dlFileEntryLocalService.getFileAsStream(dlFileVersion.getFileEntryId(), dlFileVersion.getVersion(), false);
                    }
                    catch (Exception e) {
                        if (_log.isWarnEnabled()) {
                            DLFileEntry dlFileEntry = DLServiceVerifyProcess.this._dlFileEntryLocalService.fetchDLFileEntry(dlFileVersion.getFileEntryId());
                            if (dlFileEntry == null) {
                                _log.warn((Object)("Unable to find file entry associated with file version " + dlFileVersion.getFileVersionId()), (Throwable)e);
                            } else {
                                StringBundler sb = new StringBundler(4);
                                sb.append("Unable to find file version ");
                                sb.append(dlFileVersion.getVersion());
                                sb.append(" for file entry ");
                                sb.append(dlFileEntry.getName());
                                _log.warn((Object)sb.toString(), (Throwable)e);
                            }
                        }
                        return;
                    }
                    String title = DLUtil.getTitleWithExtension((String)dlFileVersion.getTitle(), (String)dlFileVersion.getExtension());
                    String mimeType = DLServiceVerifyProcess.this.getMimeType(inputStream, title);
                    if (mimeType.equals(dlFileVersion.getMimeType())) {
                        return;
                    }
                    dlFileVersion.setMimeType(mimeType);
                    DLServiceVerifyProcess.this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
                    try {
                        DLFileEntry dlFileEntry = dlFileVersion.getFileEntry();
                        if (Objects.equals(dlFileEntry.getVersion(), dlFileVersion.getVersion())) {
                            dlFileEntry.setMimeType(mimeType);
                            DLServiceVerifyProcess.this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
                        }
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block9;
                        _log.warn((Object)("Unable to get file entry " + dlFileVersion.getFileEntryId()), (Throwable)pe);
                    }
                }
            }
        });
        if (_log.isDebugEnabled()) {
            long count = actionableDynamicQuery.performCount();
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Processing ", String.valueOf(count), " file versions with mime types: ", StringUtil.merge((Object[])originalMimeTypes, (String)",")}));
        }
        actionableDynamicQuery.performActions();
    }

    protected void checkMimeTypes() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[] mimeTypes = new String[]{"application/octet-stream", _MS_OFFICE_2010_TEXT_XML_UTF8};
            this.checkFileVersionMimeTypes(mimeTypes);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Fixed file entries with invalid mime types");
            }
        }
    }

    protected void checkMisversionedDLFileEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List dlFileEntries = this._dlFileEntryLocalService.getMisversionedFileEntries();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + dlFileEntries.size() + " misversioned file entries"));
            }
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                this.copyDLFileEntry(dlFileEntry);
                this.addDLFileVersion(dlFileEntry);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Fixed misversioned file entries");
            }
        }
    }

    protected void checkTitles() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFileEntry>(){

                public void performAction(DLFileEntry dlFileEntry) {
                    block15: {
                        block14: {
                            if (dlFileEntry.isInTrash()) {
                                return;
                            }
                            String title = dlFileEntry.getTitle();
                            if (!DLServiceVerifyProcess.this._dlValidator.isValidName(title)) {
                                try {
                                    dlFileEntry = DLServiceVerifyProcess.this.renameTitle(dlFileEntry, DLServiceVerifyProcess.this._dlValidator.fixName(title));
                                }
                                catch (Exception e) {
                                    if (!_log.isWarnEnabled()) break block14;
                                    _log.warn((Object)("Unable to rename invalid title for file entry " + dlFileEntry.getFileEntryId()), (Throwable)e);
                                }
                            }
                        }
                        if (!DLWebDAVUtil.isRepresentableTitle((String)dlFileEntry.getTitle())) {
                            try {
                                dlFileEntry = DLServiceVerifyProcess.this.renameWithRepresentableTitle(dlFileEntry);
                            }
                            catch (Exception e) {
                                if (!_log.isWarnEnabled()) break block15;
                                _log.warn((Object)("Unable to rename file entry " + dlFileEntry.getFileEntryId() + " with a WebDAV title"), (Throwable)e);
                            }
                        }
                    }
                    try {
                        DLServiceVerifyProcess.this._dlFileEntryLocalService.validateFile(dlFileEntry.getGroupId(), dlFileEntry.getFolderId(), dlFileEntry.getFileEntryId(), dlFileEntry.getFileName(), dlFileEntry.getTitle());
                    }
                    catch (DuplicateFileEntryException | DuplicateFolderNameException pe) {
                        try {
                            DLServiceVerifyProcess.this.renameDuplicateTitle(dlFileEntry);
                        }
                        catch (Exception e) {
                            if (_log.isWarnEnabled()) {
                                _log.warn((Object)("Unable to rename duplicate title for file entry " + dlFileEntry.getFileEntryId()), (Throwable)e);
                            }
                        }
                    }
                    catch (PortalException pe) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)pe, (Throwable)pe);
                        }
                        return;
                    }
                }
            });
            actionableDynamicQuery.performActions();
        }
    }

    protected void copyDLFileEntry(DLFileEntry dlFileEntry) throws PortalException {
        String version;
        String name;
        long dataRepositoryId;
        long companyId = dlFileEntry.getCompanyId();
        if (DLStoreUtil.hasFile((long)companyId, (long)(dataRepositoryId = dlFileEntry.getDataRepositoryId()), (String)(name = dlFileEntry.getName()), (String)(version = dlFileEntry.getVersion()))) {
            return;
        }
        List dlFileVersions = dlFileEntry.getFileVersions(0);
        if (dlFileVersions.isEmpty()) {
            dlFileVersions = dlFileEntry.getFileVersions(-1);
        }
        if (dlFileVersions.isEmpty()) {
            DLStoreUtil.addFile((long)companyId, (long)dataRepositoryId, (String)name, (boolean)false, (byte[])new byte[0]);
            return;
        }
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, new DLFileVersionVersionComparator());
        DLFileVersion dlFileVersion = (DLFileVersion)dlFileVersions.get(0);
        DLStoreUtil.copyFileVersion((long)companyId, (long)dataRepositoryId, (String)name, (String)dlFileVersion.getVersion(), (String)version);
    }

    protected void deleteOrphanedDLFileEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List dlFileEntries = this._dlFileEntryLocalService.getOrphanedFileEntries();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no group"));
            }
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                try {
                    this._dlFileEntryLocalService.deleteFileEntry(dlFileEntry.getFileEntryId());
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to remove file entry ", String.valueOf(dlFileEntry.getFileEntryId()), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Removed orphaned file entries");
            }
        }
    }

    protected void deleteUnusedDLFileEntryMetadata(DLFileEntryMetadata dlFileEntryMetadata) throws Exception {
        this._dlFileEntryMetadataLocalService.deleteFileEntryMetadata(dlFileEntryMetadata);
    }

    protected void doVerify() throws Exception {
        this.checkMisversionedDLFileEntries();
        this.checkDLFileEntryType();
        this.checkDLFileEntryMetadata();
        this.checkMimeTypes();
        this.checkTitles();
        this.deleteOrphanedDLFileEntries();
        this.updateClassNameId();
        this.updateFileEntryAssets();
        this.updateFolderAssets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeType(InputStream inputStream, String title) {
        String mimeType = null;
        try {
            mimeType = MimeTypesUtil.getContentType((InputStream)inputStream, (String)title);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        return mimeType;
    }

    protected void renameDuplicateTitle(DLFileEntry dlFileEntry) throws PortalException {
        String uniqueTitle = this._dlFileEntryLocalService.getUniqueTitle(dlFileEntry.getGroupId(), dlFileEntry.getFolderId(), dlFileEntry.getFileEntryId(), dlFileEntry.getTitle(), dlFileEntry.getExtension());
        this.renameTitle(dlFileEntry, uniqueTitle);
    }

    protected DLFileEntry renameTitle(DLFileEntry dlFileEntry, String newTitle) throws PortalException {
        String title = dlFileEntry.getTitle();
        dlFileEntry.setTitle(newTitle);
        String fileName = DLUtil.getSanitizedFileName((String)newTitle, (String)dlFileEntry.getExtension());
        dlFileEntry.setFileName(fileName);
        DLFileEntry renamedDLFileEntry = this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        dlFileVersion.setTitle(newTitle);
        dlFileVersion.setFileName(fileName);
        this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Invalid title ", title, " renamed to ", newTitle, " for file entry ", String.valueOf(dlFileEntry.getFileEntryId())}));
        }
        return renamedDLFileEntry;
    }

    protected DLFileEntry renameWithRepresentableTitle(DLFileEntry dlFileEntry) throws PortalException {
        String title = dlFileEntry.getTitle();
        int i = 0;
        while (true) {
            String newTitle = DLWebDAVUtil.getRepresentableTitle((String)title, (int)i);
            try {
                return this.renameTitle(dlFileEntry, newTitle);
            }
            catch (DuplicateFileEntryException dfee) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)dfee, (Throwable)dfee);
                }
                ++i;
                continue;
            }
            break;
        }
    }

    @Reference(target="(org.springframework.context.service.name=com.liferay.dynamic.data.mapping.service)", unbind="-")
    protected void setApplicationContext(ApplicationContext applicationContext) {
    }

    @Reference(unbind="-")
    protected void setCounterLocalService(CounterLocalService counterLocalService) {
        this._counterLocalService = counterLocalService;
    }

    @Reference(unbind="-")
    protected void setDLAppHelperLocalService(DLAppHelperLocalService dlAppHelperLocalService) {
        this._dlAppHelperLocalService = dlAppHelperLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryMetadataLocalService(DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService) {
        this._dlFileEntryMetadataLocalService = dlFileEntryMetadataLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryTypeLocalService(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileVersionLocalService(DLFileVersionLocalService dlFileVersionLocalService) {
        this._dlFileVersionLocalService = dlFileVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.document.library.service)(release.schema.version=1.0.0))", unbind="-")
    protected void setRelease(Release release) {
    }

    protected void updateClassNameId() {
        block14: {
            try (LoggingTimer loggingTimer = new LoggingTimer();){
                this.runSQL("update DLFileEntry set classNameId = 0 where classNameId is null");
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)"Unable to fix file entries where class name ID is null", (Throwable)e);
            }
        }
    }

    protected void updateFileEntryAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List dlFileEntries = this._dlFileEntryLocalService.getNoAssetFileEntries();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no asset"));
            }
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
                LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileEntry.getFileVersion());
                try {
                    this._dlAppHelperLocalService.updateAsset(dlFileEntry.getUserId(), (FileEntry)fileEntry, (FileVersion)fileVersion, null, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to update asset for file entry ", String.valueOf(dlFileEntry.getFileEntryId()), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for file entries");
            }
        }
    }

    protected void updateFolderAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List dlFolders = this._dlFolderLocalService.getNoAssetFolders();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + dlFolders.size() + " folders with no asset"));
            }
            for (DLFolder dlFolder : dlFolders) {
                LiferayFolder folder = new LiferayFolder(dlFolder);
                try {
                    this._dlAppHelperLocalService.updateAsset(dlFolder.getUserId(), (Folder)folder, null, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to update asset for folder ", String.valueOf(dlFolder.getFolderId()), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for folders");
            }
        }
    }
}

