/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.trash;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.UnsupportedCapabilityException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.List;

public abstract class DLBaseTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        if (containerModelId == 0L) {
            return null;
        }
        return this.getDLFolder(containerModelId);
    }

    public String getContainerModelClassName(long classPK) {
        return DLFolder.class.getName();
    }

    public String getContainerModelName() {
        return "folder";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        List folders = documentRepository.getFolders(parentContainerModelId, false, start, end, null);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>(folders.size());
        for (Folder folder : folders) {
            containerModels.add((ContainerModel)folder.getModel());
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return documentRepository.getFoldersCount(parentContainerModelId, false);
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getParentContainerModel(classPK);
        if (containerModel == null) {
            return containerModels;
        }
        containerModels.add(containerModel);
        while (containerModel.getParentContainerModelId() > 0L && (containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) != null) {
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRootContainerModelName() {
        return "folder";
    }

    public String getTrashContainedModelName() {
        return "documents";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return documentRepository.getFileEntriesAndFileShortcutsCount(classPK, 8);
    }

    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        List repositoryEntries = documentRepository.getFileEntriesAndFileShortcuts(classPK, 8, start, end);
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            String curClassName = "";
            long curClassPK = 0L;
            if (repositoryEntry instanceof FileShortcut) {
                FileShortcut fileShortcut = (FileShortcut)repositoryEntry;
                curClassName = DLFileShortcutConstants.getClassName();
                curClassPK = fileShortcut.getPrimaryKey();
            } else {
                if (!(repositoryEntry instanceof FileEntry)) continue;
                FileEntry fileEntry = (FileEntry)repositoryEntry;
                curClassName = DLFileEntry.class.getName();
                curClassPK = fileEntry.getPrimaryKey();
            }
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)curClassName);
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(curClassPK);
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public String getTrashContainerModelName() {
        return "folders";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return documentRepository.getFoldersCount(classPK, 8, false);
    }

    public List<TrashRenderer> getTrashContainerModelTrashRenderers(long classPK, int start, int end) throws PortalException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        List folders = documentRepository.getFolders(classPK, 8, false, start, end, null);
        for (Folder folder : folders) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFolder.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(folder.getPrimaryKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return documentRepository.getFileEntriesAndFileShortcutsCount(classPK, 8);
    }

    public List<TrashRenderer> getTrashModelTrashRenderers(long classPK, int start, int end, OrderByComparator obc) throws PortalException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        List repositoryEntries = documentRepository.getFoldersAndFileEntriesAndFileShortcuts(classPK, 8, false, start, end, obc);
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            TrashHandler trashHandler;
            TrashRenderer trashRenderer = null;
            if (repositoryEntry instanceof FileShortcut) {
                FileShortcut fileShortcut = (FileShortcut)repositoryEntry;
                trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFileShortcutConstants.getClassName());
                trashRenderer = trashHandler.getTrashRenderer(fileShortcut.getPrimaryKey());
            } else if (repositoryEntry instanceof FileEntry) {
                FileEntry fileEntry = (FileEntry)repositoryEntry;
                trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFileEntry.class.getName());
                trashRenderer = trashHandler.getTrashRenderer(fileEntry.getPrimaryKey());
            } else {
                Folder folder = (Folder)repositoryEntry;
                trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFolder.class.getName());
                trashRenderer = trashHandler.getTrashRenderer(folder.getPrimaryKey());
            }
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public boolean isMovable() {
        return true;
    }

    protected DLFolder fetchDLFolder(long classPK) throws PortalException {
        Repository repository = RepositoryProviderUtil.getFolderRepository((long)classPK);
        if (!repository.isCapabilityProvided(TrashCapability.class)) {
            return null;
        }
        Folder folder = repository.getFolder(classPK);
        return (DLFolder)folder.getModel();
    }

    protected DLFolder getDLFolder(long classPK) throws PortalException {
        Repository repository = RepositoryProviderUtil.getFolderRepository((long)classPK);
        if (!repository.isCapabilityProvided(TrashCapability.class)) {
            throw new UnsupportedCapabilityException(TrashCapability.class, "Repository " + repository.getRepositoryId());
        }
        Folder folder = repository.getFolder(classPK);
        return (DLFolder)folder.getModel();
    }

    protected abstract DocumentRepository getDocumentRepository(long var1) throws PortalException;
}

