/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.workflow;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={WorkflowHandler.class})
public class DLFileEntryWorkflowHandler
extends BaseWorkflowHandler<DLFileEntry> {
    private static final boolean _VISIBLE = false;
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFileVersionLocalService _dlFileVersionLocalService;
    private DLFolderLocalService _dlFolderLocalService;
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public AssetRenderer<DLFileEntry> getAssetRenderer(long classPK) throws PortalException {
        AssetRendererFactory<DLFileEntry> assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null) {
            DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getFileVersion(classPK);
            return assetRendererFactory.getAssetRenderer(dlFileVersion.getFileEntryId(), 0);
        }
        return null;
    }

    public AssetRendererFactory<DLFileEntry> getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getClassName());
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public String getType(Locale locale) {
        return ResourceActionsUtil.getModelResource((Locale)locale, (String)this.getClassName());
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        DLFolder dlFolder;
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getFileVersion(classPK);
        long folderId = dlFileVersion.getFolderId();
        while (folderId != 0L && (dlFolder = this._dlFolderLocalService.getFolder(folderId)).getRestrictionType() == 0) {
            folderId = dlFolder.getParentFolderId();
        }
        WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, DLFolder.class.getName(), folderId, dlFileVersion.getFileEntryTypeId(), true);
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, DLFolder.class.getName(), folderId, -1L, true);
        }
        return workflowDefinitionLink;
    }

    public boolean isVisible() {
        return false;
    }

    public DLFileEntry updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        return this._dlFileEntryLocalService.updateStatus(userId, classPK, status, serviceContext, workflowContext);
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileVersionLocalService(DLFileVersionLocalService dlFileVersionLocalService) {
        this._dlFileVersionLocalService = dlFileVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setWorkflowDefinitionLinkLocalService(WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) {
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
    }
}

