/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.trash;

import com.liferay.document.library.internal.trash.DLBaseTrashHandler;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.UnsupportedCapabilityException;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.trash.TrashRendererFactory;
import com.liferay.portlet.documentlibrary.service.permission.DLFileShortcutPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.trash.kernel.model.TrashEntry;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileShortcut"}, service={TrashHandler.class})
public class DLFileShortcutTrashHandler
extends DLBaseTrashHandler {
    private static final Log _log = LogFactoryUtil.getLog(DLFileShortcutTrashHandler.class);
    private DLAppLocalService _dlAppLocalService;
    private TrashRendererFactory _trashRendererFactory;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._dlAppLocalService.deleteFileShortcut(classPK);
    }

    public String getClassName() {
        return DLFileShortcutConstants.getClassName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        long parentFolderId = dlFileShortcut.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        DLFileShortcut dlFileShortcut = (DLFileShortcut)trashedModel;
        return this.getContainerModel(dlFileShortcut.getFolderId());
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        return DLUtil.getDLFileEntryControlPanelLink((PortletRequest)portletRequest, (long)dlFileShortcut.getToFileEntryId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        return DLUtil.getDLFolderControlPanelLink((PortletRequest)portletRequest, (long)dlFileShortcut.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        return DLUtil.getAbsolutePath((PortletRequest)portletRequest, (long)dlFileShortcut.getFolderId());
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        return dlFileShortcut.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        return this._trashRendererFactory.getTrashRenderer(classPK);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return DLFolderPermission.contains((PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_SHORTCUT");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isInTrash(long classPK) throws PortalException {
        try {
            DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
            return dlFileShortcut.isInTrash();
        }
        catch (UnsupportedCapabilityException uce) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)uce, (Throwable)uce);
            }
            return false;
        }
    }

    public boolean isInTrashContainer(long classPK) throws PortalException {
        try {
            DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
            return dlFileShortcut.isInTrashContainer();
        }
        catch (UnsupportedCapabilityException uce) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)uce, (Throwable)uce);
            }
            return false;
        }
    }

    public boolean isRestorable(long classPK) throws PortalException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        try {
            dlFileShortcut.getFolder();
        }
        catch (NoSuchFolderException nsfe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfe, (Throwable)nsfe);
            }
            return false;
        }
        return !dlFileShortcut.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        this._dlAppLocalService.updateFileShortcut(userId, classPK, containerModelId, dlFileShortcut.getToFileEntryId(), serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        TrashCapability trashCapability = (TrashCapability)documentRepository.getCapability(TrashCapability.class);
        Folder newFolder = null;
        if (containerModelId != 0L) {
            newFolder = documentRepository.getFolder(containerModelId);
        }
        FileShortcut fileShortcut = documentRepository.getFileShortcut(classPK);
        trashCapability.moveFileShortcutFromTrash(userId, fileShortcut, newFolder, serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        TrashCapability trashCapability = (TrashCapability)documentRepository.getCapability(TrashCapability.class);
        FileShortcut fileShortcut = documentRepository.getFileShortcut(classPK);
        trashCapability.restoreFileShortcutFromTrash(userId, fileShortcut);
    }

    protected DLFileShortcut getDLFileShortcut(long classPK) throws PortalException {
        Repository repository = RepositoryProviderUtil.getFileShortcutRepository((long)classPK);
        if (!repository.isCapabilityProvided(TrashCapability.class)) {
            throw new UnsupportedCapabilityException(TrashCapability.class, "Repository " + repository.getRepositoryId());
        }
        FileShortcut fileShortcut = repository.getFileShortcut(classPK);
        return (DLFileShortcut)fileShortcut.getModel();
    }

    @Override
    protected DocumentRepository getDocumentRepository(long classPK) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFileShortcutLocalRepository((long)classPK);
        if (!localRepository.isCapabilityProvided(TrashCapability.class)) {
            throw new UnsupportedCapabilityException(TrashCapability.class, "Repository " + localRepository.getRepositoryId());
        }
        return localRepository;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        if (dlFileShortcut.isInHiddenFolder() && actionId.equals("VIEW")) {
            return false;
        }
        return DLFileShortcutPermission.contains((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileShortcut)", unbind="-")
    protected void setTrashRendererFactory(TrashRendererFactory trashRendererFactory) {
        this._trashRendererFactory = trashRendererFactory;
    }
}

