/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.service;

import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceWrapper;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalogUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class ExternalRepositoryDLAppHelperLocalServiceWrapper
extends DLAppHelperLocalServiceWrapper {
    @Reference
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @Reference
    private RepositoryLocalService _repositoryLocalService;

    public ExternalRepositoryDLAppHelperLocalServiceWrapper() {
        super(null);
    }

    public ExternalRepositoryDLAppHelperLocalServiceWrapper(DLAppHelperLocalService dlAppHelperLocalService) {
        super(dlAppHelperLocalService);
    }

    public void addFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException {
        if (this._isEnabled(folder)) {
            super.addFolder(userId, folder, serviceContext);
        }
    }

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException {
        if (this._isEnabled(fileEntry)) {
            super.deleteFileEntry(fileEntry);
        }
    }

    public void deleteFolder(Folder folder) throws PortalException {
        if (this._isEnabled(folder)) {
            super.deleteFolder(folder);
        }
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, long assetClassPK) throws PortalException {
        if (this._isEnabled(fileEntry)) {
            super.updateFileEntry(userId, fileEntry, sourceFileVersion, destinationFileVersion, assetClassPK);
        }
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, FileVersion sourceFileVersion, FileVersion destinationFileVersion, ServiceContext serviceContext) throws PortalException {
        if (this._isEnabled(fileEntry)) {
            super.updateFileEntry(userId, fileEntry, sourceFileVersion, destinationFileVersion, serviceContext);
        }
    }

    public void updateFolder(long userId, Folder folder, ServiceContext serviceContext) throws PortalException {
        if (this._isEnabled(folder)) {
            super.updateFolder(userId, folder, serviceContext);
        }
    }

    public void updateStatus(long userId, FileEntry fileEntry, FileVersion latestFileVersion, int oldStatus, int newStatus, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (this._isEnabled(fileEntry)) {
            super.updateStatus(userId, fileEntry, latestFileVersion, oldStatus, newStatus, serviceContext, workflowContext);
        }
    }

    private boolean _isEnabled(FileEntry fileEntry) {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return false;
        }
        return !this._isExternalRepository(fileEntry.getRepositoryId());
    }

    private boolean _isEnabled(Folder folder) {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return false;
        }
        return folder.isMountPoint() || !this._isExternalRepository(folder.getRepositoryId());
    }

    private boolean _isExternalRepository(long repositoryId) {
        Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
        if (repository == null) {
            return false;
        }
        Collection externalRepositoryClassNames = RepositoryClassDefinitionCatalogUtil.getExternalRepositoryClassNames();
        return externalRepositoryClassNames.contains(repository.getClassName());
    }
}

