/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.security.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class SafePNGInputStream
extends InputStream {
    private static final int _CHUNK_ID_SIZE = 4;
    private static final int _CHUNK_LENGTH_SIZE = 4;
    private static final int _CRC_SIZE = 4;
    private static final byte[] _PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] _ZTXT_CHUNK_ID = new byte[]{122, 84, 88, 116};
    private final BufferedInputStream _bufferedInputStream;
    private boolean _firstRun = true;
    private boolean _png;
    private long _readForwardByteCount;

    public SafePNGInputStream(BufferedInputStream bufferedInputStream) {
        this._bufferedInputStream = bufferedInputStream;
    }

    @Override
    public int read() throws IOException {
        long skipped;
        if (this._firstRun) {
            this._detectPNGSignature();
            this._firstRun = false;
            this._readForwardByteCount = _PNG_SIGNATURE.length;
        }
        if (!this._png) {
            return this._bufferedInputStream.read();
        }
        if (this._readForwardByteCount > 0L) {
            --this._readForwardByteCount;
            return this._bufferedInputStream.read();
        }
        this._bufferedInputStream.mark(8);
        long chunkLength = this._readChunkLength();
        if (chunkLength == -1L) {
            this._bufferedInputStream.reset();
            return this._bufferedInputStream.read();
        }
        byte[] bytes = new byte[4];
        int n = this._bufferedInputStream.read(bytes);
        if (n != 4 || !Arrays.equals(_ZTXT_CHUNK_ID, bytes)) {
            this._bufferedInputStream.reset();
            this._readForwardByteCount = 8L + chunkLength + 4L - 1L;
            return this._bufferedInputStream.read();
        }
        for (long bytesToSkip = chunkLength + 4L; bytesToSkip > 0L && (skipped = this._bufferedInputStream.skip(bytesToSkip)) > 0L; bytesToSkip -= skipped) {
        }
        return this.read();
    }

    private void _detectPNGSignature() throws IOException {
        this._bufferedInputStream.mark(_PNG_SIGNATURE.length);
        byte[] bytes = new byte[_PNG_SIGNATURE.length];
        int n = this._bufferedInputStream.read(bytes);
        if (n == bytes.length && Arrays.equals(_PNG_SIGNATURE, bytes)) {
            this._png = true;
        }
        this._bufferedInputStream.reset();
    }

    private long _readChunkLength() throws IOException {
        byte[] bytes = new byte[8];
        Arrays.fill(bytes, (byte)0);
        int n = this._bufferedInputStream.read(bytes, bytes.length / 2, 4);
        if (n != 4) {
            return -1L;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer.getLong();
    }
}

