/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class RepositoryEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<RepositoryEntry> {
    public static final String[] CLASS_NAMES = new String[]{RepositoryEntry.class.getName()};
    private RepositoryEntryLocalService _repositoryEntryLocalService;

    public void deleteStagedModel(RepositoryEntry repositoryEntry) {
        this._repositoryEntryLocalService.deleteRepositoryEntry(repositoryEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        RepositoryEntry repositoryEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (repositoryEntry != null) {
            this.deleteStagedModel(repositoryEntry);
        }
    }

    public RepositoryEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._repositoryEntryLocalService.fetchRepositoryEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<RepositoryEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._repositoryEntryLocalService.getRepositoryEntriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, RepositoryEntry repositoryEntry) throws Exception {
        Element repositoryEntryElement = portletDataContext.getExportDataElement((ClassedModel)repositoryEntry);
        portletDataContext.addClassedModel(repositoryEntryElement, ExportImportPathUtil.getModelPath((StagedModel)repositoryEntry), (ClassedModel)repositoryEntry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, RepositoryEntry repositoryEntry) throws Exception {
        long userId = portletDataContext.getUserId(repositoryEntry.getUserUuid());
        Map repositoryIds = portletDataContext.getNewPrimaryKeysMap(Repository.class);
        long repositoryId = MapUtil.getLong((Map)repositoryIds, (long)repositoryEntry.getRepositoryId(), (long)repositoryEntry.getRepositoryId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)repositoryEntry);
        RepositoryEntry importedRepositoryEntry = null;
        if (portletDataContext.isDataStrategyMirror()) {
            RepositoryEntry existingRepositoryEntry = this.fetchStagedModelByUuidAndGroupId(repositoryEntry.getUuid(), portletDataContext.getScopeGroupId());
            if (existingRepositoryEntry == null) {
                serviceContext.setUuid(repositoryEntry.getUuid());
                importedRepositoryEntry = this._repositoryEntryLocalService.addRepositoryEntry(userId, portletDataContext.getScopeGroupId(), repositoryId, repositoryEntry.getMappedId(), serviceContext);
            } else {
                importedRepositoryEntry = this._repositoryEntryLocalService.updateRepositoryEntry(existingRepositoryEntry.getRepositoryEntryId(), repositoryEntry.getMappedId());
            }
        } else {
            importedRepositoryEntry = this._repositoryEntryLocalService.addRepositoryEntry(userId, portletDataContext.getScopeGroupId(), repositoryId, repositoryEntry.getMappedId(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)repositoryEntry, (ClassedModel)importedRepositoryEntry);
    }

    @Reference(unbind="-")
    protected void setRepositoryEntryLocalService(RepositoryEntryLocalService repositoryEntryLocalService) {
        this._repositoryEntryLocalService = repositoryEntryLocalService;
    }
}

