/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.asset.categories.validator;

import com.liferay.asset.kernel.validator.AssetEntryValidatorExclusionRule;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry", "model.class.name=com.liferay.portal.kernel.repository.model.FileEntry"}, service={AssetEntryValidatorExclusionRule.class})
public class ExternalRepositoryAssetEntryValidatorExclusionRule
implements AssetEntryValidatorExclusionRule {
    @Reference(unbind="-")
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference(unbind="-")
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public boolean isValidationExcluded(long groupId, String className, long classPK, long classTypePK, long[] categoryIds, String[] tagNames) {
        DLFileEntry dlFileEntry = this._getDLFileEntry(classPK);
        return dlFileEntry == null || dlFileEntry.getRepositoryId() != groupId;
    }

    private DLFileEntry _getDLFileEntry(long classPK) {
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(classPK);
        if (dlFileEntry != null) {
            return dlFileEntry;
        }
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.fetchDLFileVersion(classPK);
        if (dlFileVersion == null) {
            return null;
        }
        return this._dlFileEntryLocalService.fetchDLFileEntry(dlFileVersion.getFileEntryId());
    }
}

