/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.upgrade.v1_0_0;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private final Store _store;

    public UpgradeDocumentLibrary(Store store) {
        this._store = store;
    }

    protected void doUpgrade() throws Exception {
        this._deleteChecksumDirectory();
        this._deleteTempDirectory();
    }

    private void _deleteChecksumDirectory() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select distinct companyId from DLFileEntry");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                this._store.deleteDirectory(companyId, 0L, "checksum");
            }
        }
    }

    private void _deleteTempDirectory() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._store.deleteDirectory(0L, 0L, "liferay_temp/");
        }
    }
}

