/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.event;

import com.liferay.document.library.model.DLFileVersionPreview;
import com.liferay.document.library.service.DLFileVersionPreviewLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.event.FileVersionPreviewEventListener;
import com.liferay.portal.kernel.repository.model.FileVersion;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FileVersionPreviewEventListener.class})
public class FileVersionPreviewEventListenerImpl
implements FileVersionPreviewEventListener {
    private static final Log _log = LogFactoryUtil.getLog(FileVersionPreviewEventListenerImpl.class);
    @Reference
    private DLFileVersionPreviewLocalService _dlFileVersionPreviewLocalService;

    public void onFailure(FileVersion fileVersion) {
        this._addDLFileEntryPreview(fileVersion, 1);
    }

    public void onSuccess(FileVersion fileVersion) {
        this._addDLFileEntryPreview(fileVersion, 0);
    }

    private void _addDLFileEntryPreview(FileVersion fileVersion, int previewStatus) {
        block4: {
            try {
                DLFileVersionPreview dlFileVersionPreview = this._dlFileVersionPreviewLocalService.fetchDLFileVersionPreview(fileVersion.getFileEntryId(), fileVersion.getFileVersionId());
                if (dlFileVersionPreview == null) {
                    this._dlFileVersionPreviewLocalService.addDLFileVersionPreview(fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), previewStatus);
                } else {
                    this._dlFileVersionPreviewLocalService.updateDLFileVersionPreview(dlFileVersionPreview.getDlFileVersionPreviewId(), previewStatus);
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)pe, (Throwable)pe);
            }
        }
    }
}

