/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.exportimport.staged.model.repository;

import com.liferay.document.library.exportimport.data.handler.DLExportableRepositoryPublisher;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={StagedModelRepository.class})
public class FileEntryStagedModelRepository
implements StagedModelRepository<FileEntry> {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    private ServiceTrackerList<DLExportableRepositoryPublisher, DLExportableRepositoryPublisher> _dlExportableRepositoryPublishers;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;

    public FileEntry addStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void deleteStagedModel(FileEntry fileEntry) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public FileEntry fetchMissingReference(String uuid, long groupId) {
        throw new UnsupportedOperationException();
    }

    public FileEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        throw new UnsupportedOperationException();
    }

    public List<FileEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        throw new UnsupportedOperationException();
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(portletDataContext);
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._dlFileEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            DynamicQuery fileVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(DLFileVersion.class, (String)"dlFileVersion", (ClassLoader)PortalClassLoaderUtil.getClassLoader());
            fileVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"fileEntryId"));
            fileVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"dlFileVersion.fileEntryId", (String)"this.fileEntryId"));
            fileVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"dlFileVersion.version", (String)"this.version"));
            Property fileVersionStatusProperty = PropertyFactoryUtil.forName((String)"dlFileVersion.status");
            StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DLFileEntry.class.getName());
            fileVersionDynamicQuery.add(fileVersionStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
            Criterion fileVersionModifiedDateCriterion = portletDataContext.getDateRangeCriteria("dlFileVersion.modifiedDate");
            Criterion fileVersionStatusDateCriterion = portletDataContext.getDateRangeCriteria("dlFileVersion.statusDate");
            Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("this.modifiedDate");
            if (fileVersionStatusDateCriterion != null && modifiedDateCriterion != null) {
                Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(fileVersionModifiedDateCriterion);
                disjunction.add(fileVersionStatusDateCriterion);
                disjunction.add(modifiedDateCriterion);
                fileVersionDynamicQuery.add((Criterion)disjunction);
            }
            Property fileEntryIdProperty = PropertyFactoryUtil.forName((String)"fileEntryId");
            dynamicQuery.add(fileEntryIdProperty.in(fileVersionDynamicQuery));
            Property repositoryIdProperty = PropertyFactoryUtil.forName((String)"repositoryId");
            dynamicQuery.add(repositoryIdProperty.in(exportableRepositoryIds));
        });
        exportActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(dlFileEntry.getFileEntryId());
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DLFileEntryConstants.getClassName()));
        return exportActionableDynamicQuery;
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortletDataException {
        throw new UnsupportedOperationException();
    }

    public FileEntry saveStagedModel(FileEntry fileEntry) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public FileEntry updateStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._dlExportableRepositoryPublishers = ServiceTrackerListFactory.open((BundleContext)bundleContext, DLExportableRepositoryPublisher.class);
    }

    @Deactivate
    protected void deactivate() {
        if (this._dlExportableRepositoryPublishers != null) {
            this._dlExportableRepositoryPublishers.close();
        }
    }

    private Collection<Long> _getExportableRepositoryIds(PortletDataContext portletDataContext) {
        HashSet<Long> exportableRepositoryIds = new HashSet<Long>();
        exportableRepositoryIds.add(portletDataContext.getScopeGroupId());
        for (DLExportableRepositoryPublisher dlExportableRepositoryPublisher : this._dlExportableRepositoryPublishers) {
            dlExportableRepositoryPublisher.publish(portletDataContext.getScopeGroupId(), exportableRepositoryIds::add);
        }
        return exportableRepositoryIds;
    }
}

