/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.search.internal;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.repository.search.RepositorySearchQueryBuilder;
import com.liferay.portal.kernel.repository.search.RepositorySearchQueryTermBuilder;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={RepositorySearchQueryBuilder.class})
public class RepositorySearchQueryBuilderImpl
implements RepositorySearchQueryBuilder {
    private DLAppService _dlAppService;
    private RepositorySearchQueryTermBuilder _repositorySearchQueryTermBuilder;

    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        try {
            BooleanClause[] booleanClauses;
            BooleanQueryImpl contextQuery = new BooleanQueryImpl();
            this.addContext((BooleanQuery)contextQuery, searchContext);
            BooleanQueryImpl searchQuery = new BooleanQueryImpl();
            this.addSearchKeywords((BooleanQuery)searchQuery, searchContext);
            BooleanQueryImpl fullQuery = new BooleanQueryImpl();
            if (contextQuery.hasClauses()) {
                fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            }
            if (searchQuery.hasClauses()) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
                for (BooleanClause booleanClause : booleanClauses) {
                    fullQuery.add((Query)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
                }
            }
            fullQuery.setQueryConfig(searchContext.getQueryConfig());
            return fullQuery;
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    protected void addContext(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] folderIds = searchContext.getFolderIds();
        if (ArrayUtil.isEmpty((long[])folderIds)) {
            return;
        }
        if (folderIds[0] == 0L) {
            return;
        }
        BooleanQueryImpl folderIdsQuery = new BooleanQueryImpl();
        for (long folderId : folderIds) {
            try {
                this._dlAppService.getFolder(folderId);
            }
            catch (Exception e) {
                continue;
            }
            folderIdsQuery.add((Query)new TermQueryImpl("folderId", String.valueOf(folderId)), BooleanClauseOccur.SHOULD);
        }
        contextQuery.add((Query)folderIdsQuery, BooleanClauseOccur.MUST);
    }

    protected void addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            return;
        }
        BooleanQueryImpl titleQuery = new BooleanQueryImpl();
        this._repositorySearchQueryTermBuilder.addTerm((BooleanQuery)titleQuery, searchContext, "title", keywords);
        if (titleQuery.hasClauses() && !this.contains((Query)searchQuery, (Query)titleQuery)) {
            searchQuery.add((Query)titleQuery, BooleanClauseOccur.SHOULD);
        }
        BooleanQueryImpl userNameQuery = new BooleanQueryImpl();
        this._repositorySearchQueryTermBuilder.addTerm((BooleanQuery)userNameQuery, searchContext, "userName", keywords);
        if (userNameQuery.hasClauses() && !this.contains((Query)searchQuery, (Query)userNameQuery)) {
            searchQuery.add((Query)userNameQuery, BooleanClauseOccur.SHOULD);
        }
        BooleanQueryImpl contentQuery = new BooleanQueryImpl();
        this._repositorySearchQueryTermBuilder.addTerm((BooleanQuery)contentQuery, searchContext, "content", keywords);
        if (contentQuery.hasClauses() && !this.contains((Query)searchQuery, (Query)contentQuery)) {
            searchQuery.add((Query)contentQuery, BooleanClauseOccur.SHOULD);
        }
    }

    protected boolean contains(Query query1, Query query2) {
        if (query1 instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query1;
            for (BooleanClause booleanClause : booleanQuery.clauses()) {
                if (!this.contains((Query)booleanClause.getClause(), query2)) continue;
                return true;
            }
            return false;
        }
        if (query2 instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query2;
            for (BooleanClause booleanClause : booleanQuery.clauses()) {
                if (!this.contains(query1, (Query)booleanClause.getClause())) continue;
                return true;
            }
            return false;
        }
        if (query1 instanceof TermQuery && query2 instanceof TermQuery) {
            TermQuery termQuery1 = (TermQuery)query1;
            QueryTerm queryTerm1 = termQuery1.getQueryTerm();
            String field1 = queryTerm1.getField();
            String value1 = queryTerm1.getValue();
            TermQuery termQuery2 = (TermQuery)query2;
            QueryTerm queryTerm2 = termQuery2.getQueryTerm();
            String field2 = queryTerm2.getField();
            String value2 = queryTerm2.getValue();
            if (field1.equals(field2) && value1.equals(value2)) {
                return true;
            }
        } else if (query1 instanceof TermRangeQuery && query2 instanceof TermRangeQuery) {
            TermRangeQuery termRangeQuery1 = (TermRangeQuery)query1;
            boolean includesLower1 = termRangeQuery1.includesLower();
            boolean includesUpper1 = termRangeQuery1.includesUpper();
            String lowerTerm1 = termRangeQuery1.getLowerTerm();
            String upperTerm1 = termRangeQuery1.getUpperTerm();
            TermRangeQuery termRangeQuery2 = (TermRangeQuery)query2;
            boolean includesLower2 = termRangeQuery2.includesLower();
            boolean includesUpper2 = termRangeQuery2.includesUpper();
            String lowerTerm2 = termRangeQuery2.getLowerTerm();
            String upperTerm2 = termRangeQuery2.getUpperTerm();
            if (includesLower1 == includesLower2 && includesUpper1 == includesUpper2 && lowerTerm1.equals(lowerTerm2) && upperTerm1.equals(upperTerm2)) {
                return true;
            }
        } else if (query1 instanceof WildcardQuery && query2 instanceof WildcardQuery) {
            WildcardQuery wildcardQuery1 = (WildcardQuery)query1;
            QueryTerm queryTerm1 = wildcardQuery1.getQueryTerm();
            String field1 = queryTerm1.getField();
            String value1 = queryTerm1.getValue();
            WildcardQuery wildcardQuery2 = (WildcardQuery)query2;
            QueryTerm queryTerm2 = wildcardQuery2.getQueryTerm();
            String field2 = queryTerm2.getField();
            String value2 = queryTerm2.getValue();
            if (field1.equals(field2) && value1.equals(value2)) {
                return true;
            }
        }
        return false;
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    protected void setRepositorySearchQueryTermBuilder(RepositorySearchQueryTermBuilder repositorySearchQueryTermBuilder) {
        this._repositorySearchQueryTermBuilder = repositorySearchQueryTermBuilder;
    }
}

