/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.search.internal;

import com.liferay.document.library.repository.search.util.KeywordsUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.search.RepositorySearchQueryTermBuilder;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={RepositorySearchQueryTermBuilder.class})
public class LuceneRepositorySearchQueryTermBuilder
implements RepositorySearchQueryTermBuilder {
    private static final Log _log = LogFactoryUtil.getLog(LuceneRepositorySearchQueryTermBuilder.class);
    private Analyzer _analyzer;

    public void addTerm(BooleanQuery booleanQuery, SearchContext searchContext, String field, String value) {
        if (Validator.isNull((String)value)) {
            return;
        }
        try {
            QueryParser queryParser = new QueryParser(field, this._analyzer);
            queryParser.setAllowLeadingWildcard(true);
            queryParser.setLowercaseExpandedTerms(false);
            Query query = null;
            try {
                query = queryParser.parse(value);
            }
            catch (Exception e) {
                query = queryParser.parse(KeywordsUtil.escape(value));
            }
            this.translateQuery(booleanQuery, searchContext, query, BooleanClause.Occur.SHOULD);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._analyzer = new KeywordAnalyzer();
    }

    protected BooleanClauseOccur getBooleanClauseOccur(BooleanClause.Occur occur) {
        if (occur.equals((Object)BooleanClause.Occur.MUST)) {
            return BooleanClauseOccur.MUST;
        }
        if (occur.equals((Object)BooleanClause.Occur.MUST_NOT)) {
            return BooleanClauseOccur.MUST_NOT;
        }
        return BooleanClauseOccur.SHOULD;
    }

    protected BooleanClause.Occur getBooleanClauseOccur(BooleanClauseOccur occur) {
        if (occur.equals(BooleanClauseOccur.MUST)) {
            return BooleanClause.Occur.MUST;
        }
        if (occur.equals(BooleanClauseOccur.MUST_NOT)) {
            return BooleanClause.Occur.MUST_NOT;
        }
        return BooleanClause.Occur.SHOULD;
    }

    protected void translateQuery(BooleanQuery booleanQuery, SearchContext searchContext, Query query, BooleanClause.Occur occur) throws Exception {
        BooleanClauseOccur booleanClauseOccur = this.getBooleanClauseOccur(occur);
        if (query instanceof TermQuery) {
            TermQuery luceneTermQuery = (TermQuery)query;
            Term term = luceneTermQuery.getTerm();
            String termValue = term.text();
            TermQueryImpl termQuery = new TermQueryImpl(term.field(), termValue);
            booleanQuery.add((com.liferay.portal.kernel.search.Query)termQuery, this.getBooleanClauseOccur(occur));
        } else if (query instanceof org.apache.lucene.search.BooleanQuery) {
            org.apache.lucene.search.BooleanQuery curBooleanQuery = (org.apache.lucene.search.BooleanQuery)query;
            BooleanQueryImpl conjunctionQuery = new BooleanQueryImpl();
            BooleanQueryImpl disjunctionQuery = new BooleanQueryImpl();
            for (BooleanClause booleanClause : curBooleanQuery.getClauses()) {
                BooleanClauseOccur curBooleanClauseOccur = this.getBooleanClauseOccur(booleanClause.getOccur());
                BooleanQueryImpl subbooleanQuery = null;
                subbooleanQuery = curBooleanClauseOccur.equals(BooleanClauseOccur.SHOULD) ? disjunctionQuery : conjunctionQuery;
                this.translateQuery((BooleanQuery)subbooleanQuery, searchContext, booleanClause.getQuery(), booleanClause.getOccur());
            }
            if (conjunctionQuery.hasClauses()) {
                booleanQuery.add((com.liferay.portal.kernel.search.Query)conjunctionQuery, BooleanClauseOccur.MUST);
            }
            if (disjunctionQuery.hasClauses()) {
                booleanQuery.add((com.liferay.portal.kernel.search.Query)disjunctionQuery, BooleanClauseOccur.SHOULD);
            }
        } else if (query instanceof FuzzyQuery) {
            FuzzyQuery fuzzyQuery = (FuzzyQuery)query;
            Term term = fuzzyQuery.getTerm();
            String termValue = term.text().concat("*");
            WildcardQueryImpl wildcardQuery = new WildcardQueryImpl(term.field(), termValue);
            booleanQuery.add((com.liferay.portal.kernel.search.Query)wildcardQuery, booleanClauseOccur);
        } else if (query instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query;
            Term[] terms = phraseQuery.getTerms();
            StringBundler sb = new StringBundler(terms.length * 2);
            for (Term term : terms) {
                sb.append(term.text());
                sb.append(" ");
            }
            TermQueryImpl termQuery = new TermQueryImpl(terms[0].field(), StringUtil.trim((String)sb.toString()));
            booleanQuery.add((com.liferay.portal.kernel.search.Query)termQuery, booleanClauseOccur);
        } else if (query instanceof PrefixQuery) {
            PrefixQuery prefixQuery = (PrefixQuery)query;
            Term prefixTerm = prefixQuery.getPrefix();
            String termValue = prefixTerm.text().concat("*");
            WildcardQueryImpl wildcardQuery = new WildcardQueryImpl(prefixTerm.field(), termValue);
            booleanQuery.add((com.liferay.portal.kernel.search.Query)wildcardQuery, booleanClauseOccur);
        } else if (query instanceof TermRangeQuery) {
            TermRangeQuery termRangeQuery = (TermRangeQuery)query;
            BytesRef lowerTerm = termRangeQuery.getLowerTerm();
            BytesRef upperTerm = termRangeQuery.getUpperTerm();
            booleanQuery.addRangeTerm(termRangeQuery.getField(), lowerTerm.utf8ToString(), upperTerm.utf8ToString());
        } else if (query instanceof WildcardQuery) {
            WildcardQuery luceneWildcardQuery = (WildcardQuery)query;
            Term wildcardTerm = luceneWildcardQuery.getTerm();
            WildcardQueryImpl wildcardQuery = new WildcardQueryImpl(wildcardTerm.field(), wildcardTerm.text());
            booleanQuery.add((com.liferay.portal.kernel.search.Query)wildcardQuery, booleanClauseOccur);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Ignoring unknown query type ", query.getClass(), " with query ", query}));
        }
    }
}

